"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverSessionView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _useLatest = _interopRequireDefault(require("react-use/lib/useLatest"));
var _public2 = require("@kbn/kibana-react-plugin/public");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _use_url = require("../../hooks/use_url");
var _use_alert_results_toast = require("../../hooks/use_alert_results_toast");
var _data_sources = require("../../../../../common/data_sources");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _discover_state = require("../../state_management/discover_state");
var _redux = require("../../state_management/redux");
var _customizations = require("../../../../customizations");
var _error_alert = require("../../../../components/common/error_alert");
var _no_data_page = require("./no_data_page");
var _discover_state_provider = require("../../state_management/discover_state_provider");
var _branded_loading_indicator = require("./branded_loading_indicator");
var _redirect_not_found = require("./redirect_not_found");
var _main_app = require("./main_app");
var _use_async_function = require("../../hooks/use_async_function");
var _scoped_services_provider = require("../../../../components/scoped_services_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DiscoverSessionView = ({
  customizationContext,
  customizationCallbacks,
  urlStateStorage,
  internalState,
  runtimeStateManager
}) => {
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    core,
    history,
    getScopedHistory
  } = services;
  const {
    id: discoverSessionId
  } = (0, _reactRouterDom.useParams)();
  const currentTabId = (0, _redux.useCurrentTabSelector)(tab => tab.id);
  const currentStateContainer = (0, _redux.useCurrentTabRuntimeState)(runtimeStateManager, tab => tab.stateContainer$);
  const currentCustomizationService = (0, _redux.useCurrentTabRuntimeState)(runtimeStateManager, tab => tab.customizationService$);
  const initializeSessionAction = (0, _redux.useCurrentTabAction)(_redux.internalStateActions.initializeSession);
  const [initializeSessionState, initializeSession] = (0, _use_async_function.useAsyncFunction)(async ({
    dataViewSpec,
    defaultUrlState,
    shouldClearAllTabs = false
  } = {}) => {
    const stateContainer = (0, _discover_state.getDiscoverStateContainer)({
      tabId: currentTabId,
      services,
      customizationContext,
      stateStorageContainer: urlStateStorage,
      internalState,
      runtimeStateManager
    });
    const customizationService = await (0, _customizations.getConnectedCustomizationService)({
      stateContainer,
      customizationCallbacks
    });
    return dispatch(initializeSessionAction({
      initializeSessionParams: {
        stateContainer,
        customizationService,
        discoverSessionId,
        dataViewSpec,
        defaultUrlState,
        shouldClearAllTabs
      }
    }));
  }, currentStateContainer && currentCustomizationService ? {
    loading: false,
    value: {
      showNoDataPage: false
    }
  } : {
    loading: true
  });
  const initializeSessionWithDefaultLocationState = (0, _useLatest.default)(options => {
    var _getScopedHistory;
    const historyLocationState = (_getScopedHistory = getScopedHistory()) === null || _getScopedHistory === void 0 ? void 0 : _getScopedHistory.location.state;
    initializeSession({
      dataViewSpec: historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.dataViewSpec,
      defaultUrlState: historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.defaultState,
      shouldClearAllTabs: options === null || options === void 0 ? void 0 : options.shouldClearAllTabs
    });
  });
  const initializationState = (0, _redux.useInternalStateSelector)(state => state.initializationState);
  const scopedProfilesManager = (0, _redux.useCurrentTabRuntimeState)(runtimeStateManager, tab => tab.scopedProfilesManager$);
  const scopedEbtManager = (0, _redux.useCurrentTabRuntimeState)(runtimeStateManager, tab => tab.scopedEbtManager$);
  const currentDataView = (0, _redux.useCurrentTabRuntimeState)(runtimeStateManager, tab => tab.currentDataView$);
  const adHocDataViews = (0, _redux.useRuntimeState)(runtimeStateManager.adHocDataViews$);
  (0, _useMount.default)(() => {
    if (!currentStateContainer || !currentCustomizationService) {
      initializeSessionWithDefaultLocationState.current();
    }
  });
  (0, _useUpdateEffect.default)(() => {
    initializeSessionWithDefaultLocationState.current();
  }, [discoverSessionId, initializeSessionWithDefaultLocationState]);
  (0, _use_url.useUrl)({
    history,
    savedSearchId: discoverSessionId,
    onNewUrl: () => {
      initializeSessionWithDefaultLocationState.current({
        shouldClearAllTabs: true
      });
    }
  });
  (0, _use_alert_results_toast.useAlertResultsToast)();
  (0, _public2.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'app',
    id: discoverSessionId || 'new'
  });
  if (initializeSessionState.loading) {
    return /*#__PURE__*/_react.default.createElement(_branded_loading_indicator.BrandedLoadingIndicator, null);
  }
  if (initializeSessionState.error) {
    if (initializeSessionState.error instanceof _public.SavedObjectNotFound) {
      return /*#__PURE__*/_react.default.createElement(_redirect_not_found.RedirectWhenSavedObjectNotFound, {
        error: initializeSessionState.error,
        discoverSessionId: discoverSessionId
      });
    }
    return /*#__PURE__*/_react.default.createElement(_error_alert.DiscoverError, {
      error: initializeSessionState.error
    });
  }
  if (initializeSessionState.value.showNoDataPage) {
    return /*#__PURE__*/_react.default.createElement(_no_data_page.NoDataPage, (0, _extends2.default)({}, initializationState, {
      onDataViewCreated: async dataViewUnknown => {
        await dispatch(_redux.internalStateActions.loadDataViewList());
        dispatch(_redux.internalStateActions.setInitializationState({
          hasESData: true,
          hasUserDataView: true
        }));
        const dataView = dataViewUnknown;
        initializeSession({
          defaultUrlState: dataView.id ? {
            dataSource: (0, _data_sources.createDataViewDataSource)({
              dataViewId: dataView.id
            })
          } : undefined
        });
      },
      onESQLNavigationComplete: () => {
        initializeSession();
      }
    }));
  }
  if (!currentStateContainer || !currentCustomizationService || !currentDataView) {
    return /*#__PURE__*/_react.default.createElement(_branded_loading_indicator.BrandedLoadingIndicator, null);
  }
  return /*#__PURE__*/_react.default.createElement(_customizations.DiscoverCustomizationProvider, {
    value: currentCustomizationService
  }, /*#__PURE__*/_react.default.createElement(_discover_state_provider.DiscoverMainProvider, {
    value: currentStateContainer
  }, /*#__PURE__*/_react.default.createElement(_redux.RuntimeStateProvider, {
    currentDataView: currentDataView,
    adHocDataViews: adHocDataViews
  }, /*#__PURE__*/_react.default.createElement(_scoped_services_provider.ScopedServicesProvider, {
    scopedProfilesManager: scopedProfilesManager,
    scopedEBTManager: scopedEbtManager
  }, /*#__PURE__*/_react.default.createElement(_main_app.DiscoverMainApp, {
    stateContainer: currentStateContainer
  })))));
};
exports.DiscoverSessionView = DiscoverSessionView;