"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ColorRow = ({
  color,
  index,
  fieldType,
  showDeleteButton,
  onColorChange,
  onRemoveColor
}) => {
  const {
    range,
    regex,
    boolean,
    text,
    background
  } = color;
  const getInputByFieldType = () => {
    if (fieldType === 'boolean') return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      prepend: _i18n.i18n.translate('indexPatternFieldEditor.color.booleanLabel', {
        defaultMessage: 'Boolean'
      }),
      options: [{
        value: 'true',
        text: 'true'
      }, {
        value: 'false',
        text: 'false'
      }],
      value: boolean,
      "data-test-subj": `colorEditorKeyBoolean ${index}`,
      onChange: e => {
        onColorChange({
          boolean: e.target.value
        }, index);
      }
    });
    if (fieldType === 'string') return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      prepend: _i18n.i18n.translate('indexPatternFieldEditor.color.patternLabel', {
        defaultMessage: 'Pattern'
      }),
      value: regex,
      "data-test-subj": `colorEditorKeyPattern ${index}`,
      onChange: e => {
        onColorChange({
          regex: e.target.value
        }, index);
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      prepend: _i18n.i18n.translate('indexPatternFieldEditor.color.rangeLabel', {
        defaultMessage: 'Range'
      }),
      value: range,
      "data-test-subj": `colorEditorKeyRange ${index}`,
      onChange: e => {
        onColorChange({
          range: e.target.value
        }, index);
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, getInputByFieldType()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    color: text,
    "data-test-subj": `colorEditorColorPicker ${index}`,
    onChange: newColor => {
      onColorChange({
        text: newColor
      }, index);
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      minWidth: "false",
      iconType: "lettering",
      color: "text",
      onClick: () => {},
      "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.color.letteringButtonAriaLabel', {
        defaultMessage: 'Select a text color for item {index}',
        values: {
          index
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": text,
      color: text,
      size: "l",
      type: "stopFilled",
      "data-test-subj": "buttonColorSwatchIcon"
    })),
    secondaryInputDisplay: "bottom"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    color: background,
    "data-test-subj": `colorEditorBackgroundPicker ${index}`,
    onChange: newColor => {
      onColorChange({
        background: newColor
      }, index);
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      minWidth: "false",
      iconType: "color",
      color: "text",
      onClick: () => {},
      "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.color.letteringButtonAriaLabel', {
        defaultMessage: 'Select a background color for item {index}',
        values: {
          index
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": background,
      color: background,
      size: "l",
      type: "stopFilled",
      "data-test-subj": "buttonColorSwatchIcon"
    })),
    secondaryInputDisplay: "bottom"
  })), showDeleteButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    onClick: () => {
      onRemoveColor(index);
    },
    "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.color.deleteTitle', {
      defaultMessage: 'Delete color format'
    }),
    "data-test-subj": "colorEditorRemoveColor"
  })));
};
exports.ColorRow = ColorRow;