"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = exports.sectionSchema = exports.searchResultsAttributesSchema = exports.referenceSchema = exports.panelSchema = exports.panelGridDataSchema = exports.optionsSchema = exports.dashboardUpdateOptionsSchema = exports.dashboardSearchResultsSchema = exports.dashboardSearchOptionsSchema = exports.dashboardItemSchema = exports.dashboardGetResultSchema = exports.dashboardCreateResultSchema = exports.dashboardCreateOptionsSchema = exports.dashboardAttributesSchema = exports.controlGroupInputSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _common = require("@kbn/controls-plugin/common");
var _esQuery = require("@kbn/es-query");
var _search = require("@kbn/data-plugin/common/search");
var _content_management = require("../../../common/content_management");
var _transform_utils = require("./transform_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const apiError = _configSchema.schema.object({
  error: _configSchema.schema.string(),
  message: _configSchema.schema.string(),
  statusCode: _configSchema.schema.number(),
  metadata: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))
});

// This schema should be provided by the controls plugin. Perhaps we can resolve this with the embeddable registry.
// See https://github.com/elastic/kibana/issues/192622
const controlGroupInputSchema = exports.controlGroupInputSchema = _configSchema.schema.object({
  controls: _configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string({
      meta: {
        description: 'The type of the control panel.'
      }
    }),
    controlConfig: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
    id: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'The unique ID of the control.'
      }
    })),
    order: _configSchema.schema.number({
      meta: {
        description: 'The order of the control panel in the control group.'
      }
    }),
    width: _configSchema.schema.oneOf(Object.values(_common.CONTROL_WIDTH_OPTIONS).map(value => _configSchema.schema.literal(value)), {
      defaultValue: _common.DEFAULT_CONTROL_WIDTH,
      meta: {
        description: 'Minimum width of the control panel in the control group.'
      }
    }),
    grow: _configSchema.schema.boolean({
      defaultValue: _common.DEFAULT_CONTROL_GROW,
      meta: {
        description: 'Expand width of the control panel to fit available space.'
      }
    })
  }, {
    unknowns: 'allow'
  }), {
    defaultValue: [],
    meta: {
      description: 'An array of control panels and their state in the control group.'
    }
  }),
  labelPosition: _configSchema.schema.oneOf(Object.values(_common.CONTROL_LABEL_POSITION_OPTIONS).map(value => _configSchema.schema.literal(value)), {
    defaultValue: _common.DEFAULT_CONTROL_LABEL_POSITION,
    meta: {
      description: 'Position of the labels for controls. For example, "oneLine", "twoLine".'
    }
  }),
  chainingSystem: _configSchema.schema.oneOf(Object.values(_common.CONTROL_CHAINING_OPTIONS).map(value => _configSchema.schema.literal(value)), {
    defaultValue: _common.DEFAULT_CONTROL_CHAINING,
    meta: {
      description: 'The chaining strategy for multiple controls. For example, "HIERARCHICAL" or "NONE".'
    }
  }),
  enhancements: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
  ignoreParentSettings: _configSchema.schema.object({
    ignoreFilters: _configSchema.schema.boolean({
      meta: {
        description: 'Ignore global filters in controls.'
      },
      defaultValue: _common.DEFAULT_IGNORE_PARENT_SETTINGS.ignoreFilters
    }),
    ignoreQuery: _configSchema.schema.boolean({
      meta: {
        description: 'Ignore the global query bar in controls.'
      },
      defaultValue: _common.DEFAULT_IGNORE_PARENT_SETTINGS.ignoreQuery
    }),
    ignoreTimerange: _configSchema.schema.boolean({
      meta: {
        description: 'Ignore the global time range in controls.'
      },
      defaultValue: _common.DEFAULT_IGNORE_PARENT_SETTINGS.ignoreTimerange
    }),
    ignoreValidations: _configSchema.schema.boolean({
      meta: {
        description: 'Ignore validations in controls.'
      },
      defaultValue: _common.DEFAULT_IGNORE_PARENT_SETTINGS.ignoreValidations
    })
  }),
  autoApplySelections: _configSchema.schema.boolean({
    meta: {
      description: 'Show apply selections button in controls.'
    },
    defaultValue: _common.DEFAULT_AUTO_APPLY_SELECTIONS
  })
});
const searchSourceSchema = _configSchema.schema.object({
  type: _configSchema.schema.maybe(_configSchema.schema.string()),
  query: _configSchema.schema.maybe(_configSchema.schema.object({
    query: _configSchema.schema.oneOf([_configSchema.schema.string({
      meta: {
        description: 'A text-based query such as Kibana Query Language (KQL) or Lucene query language.'
      }
    }), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())]),
    language: _configSchema.schema.string({
      meta: {
        description: 'The query language such as KQL or Lucene.'
      }
    })
  })),
  filter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    meta: _configSchema.schema.object({
      alias: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
      disabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
      negate: _configSchema.schema.maybe(_configSchema.schema.boolean()),
      controlledBy: _configSchema.schema.maybe(_configSchema.schema.string()),
      group: _configSchema.schema.maybe(_configSchema.schema.string()),
      index: _configSchema.schema.maybe(_configSchema.schema.string()),
      isMultiIndex: _configSchema.schema.maybe(_configSchema.schema.boolean()),
      type: _configSchema.schema.maybe(_configSchema.schema.string()),
      key: _configSchema.schema.maybe(_configSchema.schema.string()),
      params: _configSchema.schema.maybe(_configSchema.schema.any()),
      value: _configSchema.schema.maybe(_configSchema.schema.string()),
      field: _configSchema.schema.maybe(_configSchema.schema.string())
    }, {
      unknowns: 'allow'
    }),
    query: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
    $state: _configSchema.schema.maybe(_configSchema.schema.object({
      store: _configSchema.schema.oneOf([_configSchema.schema.literal(_esQuery.FilterStateStore.APP_STATE), _configSchema.schema.literal(_esQuery.FilterStateStore.GLOBAL_STATE)], {
        meta: {
          description: "Denote whether a filter is specific to an application's context (e.g. 'appState') or whether it should be applied globally (e.g. 'globalState')."
        }
      })
    }))
  }, {
    meta: {
      description: 'A filter for the search source.'
    }
  }))),
  sort: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.oneOf([_configSchema.schema.oneOf([_configSchema.schema.literal(_search.SortDirection.asc), _configSchema.schema.literal(_search.SortDirection.desc)]), _configSchema.schema.object({
    order: _configSchema.schema.oneOf([_configSchema.schema.literal(_search.SortDirection.asc), _configSchema.schema.literal(_search.SortDirection.desc)]),
    format: _configSchema.schema.maybe(_configSchema.schema.string())
  }), _configSchema.schema.object({
    order: _configSchema.schema.oneOf([_configSchema.schema.literal(_search.SortDirection.asc), _configSchema.schema.literal(_search.SortDirection.desc)]),
    numeric_type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('double'), _configSchema.schema.literal('long'), _configSchema.schema.literal('date'), _configSchema.schema.literal('date_nanos')]))
  })]))))
},
/**
 The Dashboard _should_ only ever uses the query and filters fields on the search
 source. But we should be liberal in what we accept, so we allow unknowns.
 */
{
  defaultValue: {},
  unknowns: 'allow'
});
const sectionGridDataSchema = _configSchema.schema.object({
  y: _configSchema.schema.number({
    meta: {
      description: 'The y coordinate of the section in grid units'
    }
  }),
  i: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The unique identifier of the section'
    }
  }))
});
const panelGridDataSchema = exports.panelGridDataSchema = _configSchema.schema.object({
  x: _configSchema.schema.number({
    meta: {
      description: 'The x coordinate of the panel in grid units'
    }
  }),
  y: _configSchema.schema.number({
    meta: {
      description: 'The y coordinate of the panel in grid units'
    }
  }),
  w: _configSchema.schema.number({
    defaultValue: _content_management.DEFAULT_PANEL_WIDTH,
    min: 1,
    max: _content_management.DASHBOARD_GRID_COLUMN_COUNT,
    meta: {
      description: 'The width of the panel in grid units'
    }
  }),
  h: _configSchema.schema.number({
    defaultValue: _content_management.DEFAULT_PANEL_HEIGHT,
    min: 1,
    meta: {
      description: 'The height of the panel in grid units'
    }
  }),
  i: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The unique identifier of the panel'
    }
  }))
});
const panelSchema = exports.panelSchema = _configSchema.schema.object({
  panelConfig: _configSchema.schema.object({}, {
    unknowns: 'allow'
  }),
  type: _configSchema.schema.string({
    meta: {
      description: 'The embeddable type'
    }
  }),
  panelRefName: _configSchema.schema.maybe(_configSchema.schema.string()),
  gridData: panelGridDataSchema,
  panelIndex: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The unique ID of the panel.'
    }
  })),
  version: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: "The version was used to store Kibana version information from versions 7.3.0 -> 8.11.0. As of version 8.11.0, the versioning information is now per-embeddable-type and is stored on the embeddable's input. (panelConfig in this type).",
      deprecated: true
    }
  }))
});
const sectionSchema = exports.sectionSchema = _configSchema.schema.object({
  title: _configSchema.schema.string({
    meta: {
      description: 'The title of the section.'
    }
  }),
  collapsed: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'The collapsed state of the section.'
    },
    defaultValue: false
  })),
  gridData: sectionGridDataSchema,
  panels: _configSchema.schema.arrayOf(panelSchema, {
    meta: {
      description: 'The panels that belong to the section.'
    },
    defaultValue: []
  })
});
const optionsSchema = exports.optionsSchema = _configSchema.schema.object({
  hidePanelTitles: _configSchema.schema.boolean({
    defaultValue: _content_management.DEFAULT_DASHBOARD_OPTIONS.hidePanelTitles,
    meta: {
      description: 'Hide the panel titles in the dashboard.'
    }
  }),
  useMargins: _configSchema.schema.boolean({
    defaultValue: _content_management.DEFAULT_DASHBOARD_OPTIONS.useMargins,
    meta: {
      description: 'Show margins between panels in the dashboard layout.'
    }
  }),
  syncColors: _configSchema.schema.boolean({
    defaultValue: _content_management.DEFAULT_DASHBOARD_OPTIONS.syncColors,
    meta: {
      description: 'Synchronize colors between related panels in the dashboard.'
    }
  }),
  syncTooltips: _configSchema.schema.boolean({
    defaultValue: _content_management.DEFAULT_DASHBOARD_OPTIONS.syncTooltips,
    meta: {
      description: 'Synchronize tooltips between related panels in the dashboard.'
    }
  }),
  syncCursor: _configSchema.schema.boolean({
    defaultValue: _content_management.DEFAULT_DASHBOARD_OPTIONS.syncCursor,
    meta: {
      description: 'Synchronize cursor position between related panels in the dashboard.'
    }
  })
});

// These are the attributes that are returned in search results
const searchResultsAttributesSchema = exports.searchResultsAttributesSchema = _configSchema.schema.object({
  title: _configSchema.schema.string({
    meta: {
      description: 'A human-readable title for the dashboard'
    }
  }),
  description: _configSchema.schema.string({
    defaultValue: '',
    meta: {
      description: 'A short description.'
    }
  }),
  timeRestore: _configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'Whether to restore time upon viewing this dashboard'
    }
  }),
  tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'An array of tags applied to this dashboard'
    }
  })))
});
const dashboardAttributesSchema = exports.dashboardAttributesSchema = searchResultsAttributesSchema.extends({
  // Search
  kibanaSavedObjectMeta: _configSchema.schema.object({
    searchSource: _configSchema.schema.maybe(searchSourceSchema)
  }, {
    meta: {
      description: 'A container for various metadata'
    },
    defaultValue: {}
  }),
  // Time
  timeFrom: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'An ISO string indicating when to restore time from'
    }
  })),
  timeTo: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'An ISO string indicating when to restore time from'
    }
  })),
  refreshInterval: _configSchema.schema.maybe(_configSchema.schema.object({
    pause: _configSchema.schema.boolean({
      meta: {
        description: 'Whether the refresh interval is set to be paused while viewing the dashboard.'
      }
    }),
    value: _configSchema.schema.number({
      meta: {
        description: 'A numeric value indicating refresh frequency in milliseconds.'
      }
    }),
    display: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'A human-readable string indicating the refresh frequency. No longer used.',
        deprecated: true
      }
    })),
    section: _configSchema.schema.maybe(_configSchema.schema.number({
      meta: {
        description: 'No longer used.',
        // TODO what is this legacy property?
        deprecated: true
      }
    }))
  }, {
    meta: {
      description: 'A container for various refresh interval settings'
    }
  })),
  // Dashboard Content
  controlGroupInput: _configSchema.schema.maybe(controlGroupInputSchema),
  panels: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([panelSchema, sectionSchema]), {
    defaultValue: []
  }),
  options: optionsSchema,
  version: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      deprecated: true
    }
  }))
});
const referenceSchema = exports.referenceSchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  id: _configSchema.schema.string()
}, {
  unknowns: 'forbid'
});
const dashboardAttributesSchemaResponse = dashboardAttributesSchema.extends({
  // Responses always include the panel index (for panels) and gridData.i (for panels + sections)
  panels: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([panelSchema.extends({
    panelIndex: _configSchema.schema.string(),
    gridData: panelGridDataSchema.extends({
      i: _configSchema.schema.string()
    })
  }), sectionSchema.extends({
    gridData: sectionGridDataSchema.extends({
      i: _configSchema.schema.string()
    }),
    panels: _configSchema.schema.arrayOf(panelSchema.extends({
      panelIndex: _configSchema.schema.string(),
      gridData: panelGridDataSchema.extends({
        i: _configSchema.schema.string()
      })
    }))
  })]), {
    defaultValue: []
  })
});
const dashboardItemSchema = exports.dashboardItemSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  version: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdAt: _configSchema.schema.maybe(_configSchema.schema.string()),
  updatedAt: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdBy: _configSchema.schema.maybe(_configSchema.schema.string()),
  updatedBy: _configSchema.schema.maybe(_configSchema.schema.string()),
  managed: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  error: _configSchema.schema.maybe(apiError),
  attributes: dashboardAttributesSchemaResponse,
  references: _configSchema.schema.arrayOf(referenceSchema),
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  originId: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'allow'
});
const dashboardSearchResultsSchema = exports.dashboardSearchResultsSchema = dashboardItemSchema.extends({
  attributes: searchResultsAttributesSchema
});
const dashboardSearchOptionsSchema = exports.dashboardSearchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  onlyTitle: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  includeReferences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('tag')]))),
  kuery: _configSchema.schema.maybe(_configSchema.schema.string()),
  cursor: _configSchema.schema.maybe(_configSchema.schema.number()),
  limit: _configSchema.schema.maybe(_configSchema.schema.number()),
  spaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    meta: {
      description: 'An array of spaces to search or "*" to search all spaces. Defaults to the current space if not specified.'
    }
  }))
}, {
  unknowns: 'forbid'
}));
const dashboardCreateOptionsSchema = exports.dashboardCreateOptionsSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.id),
  overwrite: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.overwrite),
  references: _configSchema.schema.maybe(_configSchema.schema.arrayOf(referenceSchema)),
  initialNamespaces: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.initialNamespaces)
});
const dashboardUpdateOptionsSchema = exports.dashboardUpdateOptionsSchema = _configSchema.schema.object({
  references: _configSchema.schema.maybe(_configSchema.schema.arrayOf(referenceSchema)),
  mergeAttributes: _configSchema.schema.maybe(_contentManagementUtils.updateOptionsSchema.mergeAttributes)
});
const dashboardGetResultSchema = exports.dashboardGetResultSchema = _configSchema.schema.object({
  item: dashboardItemSchema,
  meta: _configSchema.schema.object({
    outcome: _configSchema.schema.oneOf([_configSchema.schema.literal('exactMatch'), _configSchema.schema.literal('aliasMatch'), _configSchema.schema.literal('conflict')]),
    aliasTargetId: _configSchema.schema.maybe(_configSchema.schema.string()),
    aliasPurpose: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('savedObjectConversion'), _configSchema.schema.literal('savedObjectImport')]))
  }, {
    unknowns: 'forbid'
  })
}, {
  unknowns: 'forbid'
});
const dashboardCreateResultSchema = exports.dashboardCreateResultSchema = _configSchema.schema.object({
  item: dashboardItemSchema
}, {
  unknowns: 'forbid'
});
const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: dashboardGetResultSchema,
        down: _transform_utils.getResultV3ToV2
      }
    }
  },
  create: {
    in: {
      options: {
        schema: dashboardCreateOptionsSchema
      },
      data: {
        schema: dashboardAttributesSchema
      }
    },
    out: {
      result: {
        schema: dashboardCreateResultSchema
      }
    }
  },
  update: {
    in: {
      options: {
        schema: dashboardUpdateOptionsSchema
      },
      data: {
        schema: dashboardAttributesSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: dashboardSearchOptionsSchema
      }
    }
  }
};