"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverActionBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _suggestions_searching = require("../../../../../common/options_list/suggestions_searching");
var _options_list_context_provider = require("../options_list_context_provider");
var _options_list_popover_sorting_button = require("./options_list_popover_sorting_button");
var _options_list_strings = require("../options_list_strings");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const optionsListPopoverStyles = {
  actions: ({
    euiTheme
  }) => (0, _react2.css)`
    padding: 0 ${euiTheme.size.s};
    border-bottom: ${euiTheme.border.thin};
    border-color: ${euiTheme.colors.backgroundLightText};
  `,
  searchInputRow: ({
    euiTheme
  }) => (0, _react2.css)`
    padding-top: ${euiTheme.size.s};
  `,
  cardinalityRow: ({
    euiTheme
  }) => (0, _react2.css)`
    margin: ${euiTheme.size.xs} 0 !important;
  `,
  borderDiv: ({
    euiTheme
  }) => (0, _react2.css)`
    height: ${euiTheme.size.base};
    border-right: ${euiTheme.border.thin};
  `,
  selectAllCheckbox: ({
    euiTheme
  }) => (0, _react2.css)`
    .euiCheckbox__square {
      margin-block-start: 0;
    }
    .euiCheckbox__label {
      align-items: center;
      padding-inline-start: ${euiTheme.size.xs};
    }
  `
};
const OptionsListPopoverActionBar = ({
  showOnlySelected,
  setShowOnlySelected
}) => {
  const {
    componentApi,
    displaySettings
  } = (0, _options_list_context_provider.useOptionsListContext)();
  const [areAllSelected, setAllSelected] = (0, _react.useState)(false);

  // Using useStateFromPublishingSubject instead of useBatchedPublishingSubjects
  // to avoid debouncing input value
  const searchString = (0, _presentationPublishing.useStateFromPublishingSubject)(componentApi.searchString$);
  const [searchTechnique, searchStringValid, selectedOptions = [], totalCardinality, field, fieldName, allowExpensiveQueries, availableOptions = [], dataLoading, singleSelect] = (0, _presentationPublishing.useBatchedPublishingSubjects)(componentApi.searchTechnique$, componentApi.searchStringValid$, componentApi.selectedOptions$, componentApi.totalCardinality$, componentApi.field$, componentApi.fieldName$, componentApi.parentApi.allowExpensiveQueries$, componentApi.availableOptions$, componentApi.dataLoading$, componentApi.singleSelect$);
  const compatibleSearchTechniques = (0, _react.useMemo)(() => {
    if (!field) return [];
    return (0, _suggestions_searching.getCompatibleSearchTechniques)(field.type);
  }, [field]);
  const defaultSearchTechnique = (0, _react.useMemo)(() => searchTechnique !== null && searchTechnique !== void 0 ? searchTechnique : compatibleSearchTechniques[0], [searchTechnique, compatibleSearchTechniques]);
  const loadMoreOptions = (0, _react.useCallback)(async () => {
    componentApi.setRequestSize(Math.min(totalCardinality, _constants.MAX_OPTIONS_LIST_REQUEST_SIZE));
    componentApi.loadMoreSubject.next(); // trigger refetch with loadMoreSubject
    return (0, _rxjs.lastValueFrom)(componentApi.availableOptions$.pipe((0, _rxjs.take)(2)));
  }, [componentApi, totalCardinality]);
  const hasNoOptions = availableOptions.length < 1;
  const hasTooManyOptions = showOnlySelected ? selectedOptions.length > _constants.MAX_OPTIONS_LIST_BULK_SELECT_SIZE : totalCardinality > _constants.MAX_OPTIONS_LIST_BULK_SELECT_SIZE;
  const isBulkSelectDisabled = dataLoading || hasNoOptions || hasTooManyOptions || showOnlySelected;
  const handleBulkAction = (0, _react.useCallback)(async bulkAction => {
    bulkAction(availableOptions.map(({
      value
    }) => value));
    if (totalCardinality > availableOptions.length) {
      var _await$loadMoreOption;
      const newAvailableOptions = (_await$loadMoreOption = await loadMoreOptions()) !== null && _await$loadMoreOption !== void 0 ? _await$loadMoreOption : [];
      bulkAction(newAvailableOptions.map(({
        value
      }) => value));
    }
  }, [availableOptions, loadMoreOptions, totalCardinality]);
  (0, _react.useEffect)(() => {
    if (availableOptions.some(({
      value
    }) => !selectedOptions.includes(value))) {
      if (areAllSelected) {
        setAllSelected(false);
      }
    } else {
      if (!areAllSelected) {
        setAllSelected(true);
      }
    }
  }, [availableOptions, selectedOptions, areAllSelected]);
  const styles = (0, _use_memo_css.useMemoCss)(optionsListPopoverStyles);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "optionsList__actions",
    css: styles.actions
  }, compatibleSearchTechniques.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    css: styles.searchInputRow
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    isInvalid: !searchStringValid,
    compressed: true,
    disabled: showOnlySelected,
    fullWidth: true,
    onChange: event => {
      componentApi.setSearchString(event.target.value);
    },
    value: searchString,
    "data-test-subj": "optionsList-control-search-input",
    placeholder: _options_list_strings.OptionsListStrings.popover.getSearchPlaceholder(allowExpensiveQueries ? defaultSearchTechnique : 'exact'),
    "aria-label": _options_list_strings.OptionsListStrings.popover.getSearchAriaLabel(fieldName)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    css: styles.cardinalityRow
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, allowExpensiveQueries && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    "data-test-subj": "optionsList-cardinality-label"
  }, _options_list_strings.OptionsListStrings.popover.getCardinalityLabel(totalCardinality))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.borderDiv
  }))), !singleSelect && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: hasTooManyOptions ? _options_list_strings.OptionsListStrings.popover.getMaximumBulkSelectionTooltip() : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    checked: areAllSelected,
    id: `optionsList-control-selectAll-checkbox-${componentApi.uuid}`
    // indeterminate={selectedOptions.length > 0 && !areAllSelected}
    ,
    disabled: isBulkSelectDisabled,
    "data-test-subj": "optionsList-control-selectAll",
    onChange: () => {
      if (areAllSelected) {
        handleBulkAction(componentApi.deselectAll);
        setAllSelected(false);
      } else {
        handleBulkAction(componentApi.selectAll);
        setAllSelected(true);
      }
    },
    css: styles.selectAllCheckbox,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, _options_list_strings.OptionsListStrings.popover.getSelectAllButtonLabel())
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: showOnlySelected ? _options_list_strings.OptionsListStrings.popover.getAllOptionsButtonTitle() : _options_list_strings.OptionsListStrings.popover.getSelectedOptionsButtonTitle(),
    disableScreenReaderOutput: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "list",
    "aria-pressed": showOnlySelected,
    color: showOnlySelected ? 'primary' : 'text',
    display: showOnlySelected ? 'base' : 'empty',
    onClick: () => setShowOnlySelected(!showOnlySelected),
    "data-test-subj": "optionsList-control-show-only-selected",
    "aria-label": showOnlySelected ? _options_list_strings.OptionsListStrings.popover.getAllOptionsButtonTitle() : _options_list_strings.OptionsListStrings.popover.getSelectedOptionsButtonTitle()
  }))), !displaySettings.hideSort && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_options_list_popover_sorting_button.OptionsListPopoverSortingButton, {
    showOnlySelected: showOnlySelected
  })))))));
};
exports.OptionsListPopoverActionBar = OptionsListPopoverActionBar;