"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatCard = exports.ConnectorStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _searchConnectors = require("@kbn/search-connectors");
var _routes = require("../routes");
var _connector_status_helpers = require("../../utils/connector_status_helpers");
var _agentless_status_badge = require("./agentless_status_badge");
var _connector_detail = require("./connector_detail");
var _encode_path_params = require("../shared/encode_path_params");
var _app_context = require("../../app_context");
var _react_router_helpers = require("../shared/react_router_helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatCard = ({
  title,
  content,
  footer
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    hasBorder: true,
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, content))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued"
  }, footer));
};
exports.StatCard = StatCard;
const seeDocumentsLabel = _i18n.i18n.translate('xpack.contentConnectors.connectorStats.seeDocumentsTextLabel', {
  defaultMessage: 'See documents'
});
const pipelinesLabel = _i18n.i18n.translate('xpack.contentConnectors.connectorStats.managePipelines', {
  defaultMessage: 'Manage pipelines'
});
const configureLabel = _i18n.i18n.translate('xpack.contentConnectors.connectorStats.configureLink', {
  defaultMessage: 'Configure'
});
const noAgentLabel = _i18n.i18n.translate('xpack.contentConnectors.connectorStats.noAgentFound', {
  defaultMessage: 'No agent found'
});
const noPolicyLabel = _i18n.i18n.translate('xpack.contentConnectors.connectorStats.noPolicyFound', {
  defaultMessage: 'No policy found'
});
const ConnectorStats = ({
  connector,
  indexData,
  agentlessOverview
}) => {
  var _connectorDefinition$, _indexData$count, _connector$pipeline;
  const {
    connectorTypes,
    plugins: {
      discover
    }
  } = (0, _app_context.useAppContext)();
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  // TODO service_type === "" is considered unknown/custom connector multiple places replace all of them with a better solution
  const CUSTOM_CONNECTOR = (0, _react.useMemo)(() => connectorTypes.filter(({
    serviceType
  }) => serviceType === ''), [connectorTypes]);
  const connectorDefinition = connectorTypes.find(c => c.serviceType === connector.service_type) || CUSTOM_CONNECTOR[0];
  const columns = connector.is_native ? 2 : 3;
  const agnetlessPolicyExists = !!(agentlessOverview !== null && agentlessOverview !== void 0 && agentlessOverview.policy);
  const agentlessAgentExists = !!(agentlessOverview !== null && agentlessOverview !== void 0 && agentlessOverview.agent);
  const navigateToDiscoverPayload = agentlessAgentExists ? {
    dataViewId: 'logs-*',
    filters: [{
      meta: {
        key: 'labels.connector_id',
        index: 'logs-*',
        type: 'phrase',
        params: connector.id
      },
      query: {
        match_phrase: {
          'labels.connector_id': connector.id
        }
      }
    }, {
      meta: {
        key: 'elastic_agent.id',
        index: 'logs-*',
        type: 'phrase',
        params: connector.id
      },
      query: {
        match_phrase: {
          'elastic_agent.id': agentlessOverview.agent.id
        }
      }
    }],
    timeRange: {
      from: 'now-6h',
      to: 'now'
    },
    columns: ['message', 'log.level', 'labels.sync_job_id']
  } : {};
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: columns,
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StatCard, {
    title: _i18n.i18n.translate('xpack.contentConnectors.connectorStats.h4.connectorLabel', {
      defaultMessage: 'Connector'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      responsive: false,
      alignItems: "center",
      justifyContent: "spaceBetween"
    }, connectorDefinition && connectorDefinition.iconPath && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: connectorDefinition.iconPath,
      size: "xl"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, (_connectorDefinition$ = connectorDefinition === null || connectorDefinition === void 0 ? void 0 : connectorDefinition.name) !== null && _connectorDefinition$ !== void 0 ? _connectorDefinition$ : '-'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: (0, _connector_status_helpers.connectorStatusToColor)(connector)
    }, (0, _connector_status_helpers.connectorStatusToText)(connector)))),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.contentConnectors.connectors.connectorStats.connectorIdLabel",
      defaultMessage: "ID: {connectorId}",
      values: {
        connectorId: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, connector.id)
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: connector.id
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: copy,
      color: "text",
      iconType: "copyClipboard",
      "aria-label": _i18n.i18n.translate('xpack.contentConnectors.connectorStats.copyConnectorIdButton', {
        defaultMessage: 'Copy Connector ID'
      }),
      "data-test-subj": "copyConnectorIdButton"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, [_searchConnectors.ConnectorStatus.CONNECTED, _searchConnectors.ConnectorStatus.CONFIGURED].includes(connector.status) && connector.index_name ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      size: "s",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: connector.id,
        tabId: _connector_detail.ConnectorDetailTabId.CONFIGURATION
      })
    }, configureLabel) : /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      color: "primary",
      size: "s",
      fill: true,
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: connector.id,
        tabId: _connector_detail.ConnectorDetailTabId.CONFIGURATION
      })
    }, configureLabel)))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StatCard, {
    title: _i18n.i18n.translate('xpack.contentConnectors.connectorStats.indexTitle', {
      defaultMessage: 'Attached index'
    }),
    content: connector.index_name ? indexData ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, connector.index_name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "success"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.contentConnectors.conectors.indexHealth', {
      defaultMessage: 'Healthy'
    }))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "warning"
    }, _i18n.i18n.translate('xpack.contentConnectors.connectorStats.indexDoesntExistLabel', {
      defaultMessage: "Index doesn't exist"
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "danger"
    }, _i18n.i18n.translate('xpack.contentConnectors.connectorStats.noIndexLabel', {
      defaultMessage: 'No index attached yet'
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "documents"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.contentConnectors.connectorStats.p.DocumentsLabel', {
      defaultMessage: '{documentAmount} Documents',
      values: {
        documentAmount: (_indexData$count = indexData === null || indexData === void 0 ? void 0 : indexData.count) !== null && _indexData$count !== void 0 ? _indexData$count : 0
      }
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      isDisabled: !(connector.index_name && indexData),
      size: "s",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: connector.id,
        tabId: _connector_detail.ConnectorDetailTabId.DOCUMENTS
      })
    }, seeDocumentsLabel)))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StatCard, {
    title: _i18n.i18n.translate('xpack.contentConnectors.connectorStats.pipelinesTitle', {
      defaultMessage: 'Pipelines'
    }),
    content: connector.pipeline ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, connector.pipeline.name))) : _i18n.i18n.translate('xpack.contentConnectors.connectorStats.noPipelineText', {
      defaultMessage: 'None'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: '_blank',
      external: false,
      href: http === null || http === void 0 ? void 0 : http.basePath.prepend(`/app/management/ingest/ingest_pipelines?pipeline=${(_connector$pipeline = connector.pipeline) === null || _connector$pipeline === void 0 ? void 0 : _connector$pipeline.name}`)
    }, pipelinesLabel)))
  })), connector.is_native && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StatCard, {
    title: _i18n.i18n.translate('xpack.contentConnectors.connectorStats.integrationTitle', {
      defaultMessage: 'Integration'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      isDisabled: !connector.service_type,
      iconType: "plugs",
      color: "text",
      href: http === null || http === void 0 ? void 0 : http.basePath.prepend((0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_INTEGRATION_DETAIL_PATH, {
        serviceType: connector.service_type || ''
      }))
    }, "Elastic Connectors")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, agentlessAgentExists ? /*#__PURE__*/_react.default.createElement(_agentless_status_badge.AgentlessConnectorStatusBadge, {
      status: agentlessOverview === null || agentlessOverview === void 0 ? void 0 : agentlessOverview.agent.status
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning"
    }, noAgentLabel))),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "connectorStatsViewLogsButton",
      "aria-label": _i18n.i18n.translate('xpack.contentConnectors.connectorStats.viewLogsButtonLabel', {
        defaultMessage: 'View logs'
      }),
      disabled: !agentlessAgentExists,
      iconType: "discoverApp",
      onClick: () => {
        var _discover$locator;
        discover === null || discover === void 0 ? void 0 : (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.navigate(navigateToDiscoverPayload);
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.connectorStats.viewLogsButtonLabel', {
      defaultMessage: 'View logs'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, agentlessAgentExists && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      isDisabled: !agentlessOverview || !agentlessOverview.agent.id,
      size: "s",
      href: http === null || http === void 0 ? void 0 : http.basePath.prepend((0, _encode_path_params.generateEncodedPath)(_routes.FLEET_AGENT_DETAIL_PATH, {
        agentId: agentlessOverview.agent.id
      }))
    }, _i18n.i18n.translate('xpack.contentConnectors.connectorStats.hostOverview', {
      defaultMessage: 'Host overview'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, agnetlessPolicyExists ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      isDisabled: !agentlessOverview || !agentlessOverview.policy.id,
      size: "s",
      href: http === null || http === void 0 ? void 0 : http.basePath.prepend((0, _encode_path_params.generateEncodedPath)(_routes.FLEET_POLICY_DETAIL_PATH, {
        policyId: agentlessOverview.policy.id
      }))
    }, _i18n.i18n.translate('xpack.contentConnectors.connectorStats.managePolicy', {
      defaultMessage: 'Manage policy'
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "warning"
    }, noPolicyLabel)))
  })));
};
exports.ConnectorStats = ConnectorStats;