"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allCasesUrlStateDeserializer = void 0;
var _lodash = require("lodash");
var _constants = require("../../../../common/constants");
var _constants2 = require("../../../containers/constants");
var _sanitize_state = require("./sanitize_state");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allCasesUrlStateDeserializer = (urlParamsMap, customFieldsConfiguration = []) => {
  const queryParams = {};
  const filterOptions = {};
  for (const [key, value] of Object.entries(urlParamsMap)) {
    if (Object.hasOwn(_constants2.DEFAULT_CASES_TABLE_STATE.queryParams, key)) {
      queryParams[key] = value;
    }
    if (Object.hasOwn(_constants2.DEFAULT_CASES_TABLE_STATE.filterOptions, key)) {
      filterOptions[key] = value;
    }
  }
  const {
    page,
    perPage,
    ...restQueryParams
  } = queryParams;
  const {
    assignees,
    customFields,
    ...restFilterOptions
  } = filterOptions;
  const queryParamsParsed = {
    ...restQueryParams
  };
  const filterOptionsParsed = {
    ...restFilterOptions
  };
  if (page) {
    queryParamsParsed.page = (0, _.stringToIntegerWithDefault)(page, _constants2.DEFAULT_CASES_TABLE_STATE.queryParams.page);
  }
  if (perPage) {
    queryParamsParsed.perPage = (0, _.stringToIntegerWithDefault)(perPage, _constants2.DEFAULT_CASES_TABLE_STATE.queryParams.perPage);
  }
  if (assignees) {
    filterOptionsParsed.assignees = assignees.map(assignee => assignee === _constants.NO_ASSIGNEES_FILTERING_KEYWORD ? null : assignee);
  }
  const customFieldsParams = Object.entries(customFields !== null && customFields !== void 0 ? customFields : {}).reduce((acc, [key, value]) => {
    const foundCustomField = customFieldsConfiguration.find(cf => cf.key === key);
    if (!foundCustomField) {
      return acc;
    }
    return {
      ...acc,
      [key]: {
        type: foundCustomField.type,
        options: value
      }
    };
  }, {});
  const state = {
    queryParams: queryParamsParsed,
    filterOptions: {
      ...filterOptionsParsed,
      ...(!(0, _lodash.isEmpty)(customFieldsParams) && {
        customFields: customFieldsParams
      })
    }
  };
  return (0, _sanitize_state.sanitizeState)(state);
};
exports.allCasesUrlStateDeserializer = allCasesUrlStateDeserializer;