/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(self.apm_bundle_jsonpfunction=self.apm_bundle_jsonpfunction||[]).push([[7812],{15494:(e,n,a)=>{"use strict";a.d(n,{h:()=>Z});var t=a(84286),r=a.n(t),i=a(81319),s=a(75008),o=a(75879),m=a(96791);function l({apmServerUrl:e,secretToken:n}){const a=[{setting:"OTEL_EXPORTER_OTLP_ENDPOINT",value:e||"<apm-server-url>"},{setting:"OTEL_EXPORTER_OTLP_HEADERS",value:`Authorization=Bearer ${n||"<secret-token>"}`},{setting:"OTEL_METRICS_EXPORTER",value:"otlp",notes:"Enable metrics when supported by your OpenTelemetry client."},{setting:"OTEL_LOGS_EXPORTER",value:"otlp",notes:"Enable logs when supported by your OpenTelemetry client"},{setting:"OTEL_RESOURCE_ATTRIBUTES",value:"service.name=<app-name>,service.version=<app-version>,deployment.environment=production"}],t=[{field:"setting",width:"23%",name:s.i18n.translate("xpack.apm.tutorial.config_otel.column.configSettings",{defaultMessage:"Configuration setting (1)"})},{field:"value",width:"55%",name:s.i18n.translate("xpack.apm.tutorial.config_otel.column.configValue",{defaultMessage:"Configuration value"}),render:(e,{value:n})=>(0,m.jsx)(r().Fragment,null,(0,m.jsx)(i.EuiText,{size:"s",color:"accent"},n),n&&(0,m.jsx)(i.EuiButtonIcon,{"data-test-subj":"apmColumnsButton","aria-label":s.i18n.translate("xpack.apm.tutorial.config_otel.column.value.copyIconText",{defaultMessage:"Copy to clipboard"}),color:"text",iconType:"copy",onClick:()=>(0,i.copyToClipboard)(n)}))},{field:"notes",name:s.i18n.translate("xpack.apm.tutorial.config_otel.column.notes",{defaultMessage:"Notes"})}];return(0,m.jsx)(r().Fragment,null,(0,m.jsx)(i.EuiBasicTable,{items:a,columns:t,"data-test-subj":"otel-instructions-table"}),(0,m.jsx)(i.EuiSpacer,{size:"m"}),(0,m.jsx)(i.EuiText,{size:"xs",color:"subdued"},(0,m.jsx)(o.FormattedMessage,{id:"xpack.apm.tutorial.config_otel.description1",defaultMessage:"(1) OpenTelemetry agents and SDKs must support the {otelExporterOtlpEndpoint}, {otelExporterOtlpHeaders}, and {otelResourceAttributes} variables; some unstable components may not yet comply with this requirement.",values:{otelExporterOtlpEndpoint:(0,m.jsx)(i.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOtelExporterOtlpEndpointLink",target:"_blank",href:"https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/protocol/exporter.md"},"OTEL_EXPORTER_OTLP_ENDPOINT"),otelExporterOtlpHeaders:(0,m.jsx)(i.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOtelExporterOtlpHeadersLink",target:"_blank",href:"https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/protocol/exporter.md"},"OTEL_EXPORTER_OTLP_HEADERS"),otelResourceAttributes:(0,m.jsx)(i.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOtelResourceAttributesLink",target:"_blank",href:"https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/resource/sdk.md"},"OTEL_RESOURCE_ATTRIBUTES")}}),(0,m.jsx)(i.EuiSpacer,{size:"xs"}),(0,m.jsx)(o.FormattedMessage,{id:"xpack.apm.tutorial.config_otel.description2",defaultMessage:"The 'OTEL_METRICS_EXPORTER` and 'OTEL_LOGS_EXPORTER' environment variables may not be supported by some SDKs."}),(0,m.jsx)(i.EuiSpacer,{size:"xs"}),(0,m.jsx)(o.FormattedMessage,{id:"xpack.apm.tutorial.config_otel.description3",defaultMessage:"The exhaustive list of environment variables, command line parameters, and configuration code snippets (according to the OpenTelemetry specification) is available in the {otelInstrumentationGuide}. Some unstable OpenTelemetry clients may not support all features and may require alternate configuration mechanisms.",values:{otelInstrumentationGuide:(0,m.jsx)(i.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOpenTelemetryInstrumentationGuideLink",target:"_blank",href:"https://opentelemetry.io/docs/instrumentation"},s.i18n.translate("xpack.apm.tutorial.config_otel.instrumentationGuide",{defaultMessage:"OpenTelemetry Instrumentation guide"}))}})))}var p=a(55907);const c=s.i18n.translate("xpack.apm.tutorial.shared_clients.configure.commands.serviceNameHint",{defaultMessage:"The service name is the primary filter in the APM UI and is used to group errors and trace data together. Allowed characters are a-z, A-Z, 0-9, -, _, and space."}),u=s.i18n.translate("xpack.apm.tutorial.shared_clients.configure.commands.secretTokenHint",{defaultMessage:"Use if APM Server requires a secret token. Both the agent and APM Server must be configured with the same token. This ensures that only your agents can send data to your APM server."}),v=s.i18n.translate("xpack.apm.tutorial.shared_clients.configure.commands.serverUrlHint",{defaultMessage:"Set the custom APM Server URL (default: {defaultApmServerUrl}). The URL must be fully qualified, including protocol (http or https) and port.",values:{defaultApmServerUrl:"http://localhost:8200"}}),d=s.i18n.translate("xpack.apm.tutorial.shared_clients.configure.commands.serviceEnvironmentHint",{defaultMessage:'The name of the environment this service is deployed in, e.g., "production" or "staging". Environments allow you to easily filter data on a global level in the APM UI. It\'s important to be consistent when naming environments across agents.'}),g={apmServiceName:"Delastic.apm.service_name",secretToken:"Delastic.apm.secret_token",apmServerUrl:"Delastic.apm.server_url",apmEnvironment:"Delastic.apm.environment"},E={start:1,highlight:"",annotations:{2:c,3:u,4:v,5:d}},f=`java -javaagent:/path/to/elastic-apm-agent-<version>.jar \\\n-${g.apmServiceName}={{{apmServiceName}}} \\\n-${g.secretToken}={{{secretToken}}} \\\n-${g.apmServerUrl}={{{apmServerUrl}}} \\\n-${g.apmEnvironment}={{{apmEnvironment}}} \\\n-Delastic.apm.application_packages=org.example \\\n-jar {{{apmServiceName}}}.jar`,S={apmServiceName:"serviceName",secretToken:"secretToken",apmServerUrl:"serverUrl",apmEnvironment:"environment"},T={start:1,highlight:"3, 5, 7, 9",annotations:{3:`${c} ${s.i18n.translate("xpack.apm.tutorial.nodeClient.createConfig.commands.serviceName",{defaultMessage:"Overrides the service name in package.json."})}`,5:u,7:v,9:d}},h=`// ${s.i18n.translate("xpack.apm.tutorial.nodeClient.configure.commands.addThisToTheFileTopComment",{defaultMessage:"Add this to the very top of the first file loaded in your app"})}\nvar apm = require('elastic-apm-node').start({\n  ${S.apmServiceName}: '{{{apmServiceName}}}',\n\n  ${S.secretToken}: '{{{secretToken}}}',\n\n  ${S.apmServerUrl}: '{{{apmServerUrl}}}',\n\n  ${S.apmEnvironment}: '{{{apmEnvironment}}}'\n})`,k={apmServiceName:"SERVICE_NAME",secretToken:"SECRET_TOKEN",apmServerUrl:"SERVER_URL",apmEnvironment:"ENVIRONMENT"},_={start:1,highlight:"1-4, 7, 9, 11, 13, 16-19",annotations:{2:s.i18n.translate("xpack.apm.tutorial.djangoClient.configure.commands.addAgentComment",{defaultMessage:"Add the agent to installed apps"}),7:c,9:u,11:v,13:d,17:s.i18n.translate("xpack.apm.tutorial.djangoClient.configure.commands.addTracingMiddlewareComment",{defaultMessage:"Add our tracing middleware to send performance metrics"})}},x=`INSTALLED_APPS = (\n  'elasticapm.contrib.django',\n  # ...\n)\n\nELASTIC_APM = {\n  '${k.apmServiceName}': '{{{apmServiceName}}}',\n\n  '${k.secretToken}': '{{{secretToken}}}',\n\n  '${k.apmServerUrl}': '{{{apmServerUrl}}}',\n\n  '${k.apmEnvironment}': '{{{apmEnvironment}}}',\n}\n\nMIDDLEWARE = (\n  'elasticapm.contrib.django.middleware.TracingMiddleware',\n  #...\n)`,b={apmServiceName:"SERVICE_NAME",secretToken:"SECRET_TOKEN",apmServerUrl:"SERVER_URL",apmEnvironment:"ENVIRONMENT"},y={start:1,highlight:"2-4, 7-18",annotations:{9:c,11:u,13:v,15:d}},N=`# ${s.i18n.translate("xpack.apm.tutorial.flaskClient.configure.commands.initializeUsingEnvironmentVariablesComment",{defaultMessage:"Initialize using environment variables"})}\nfrom elasticapm.contrib.flask import ElasticAPM\napp = Flask(__name__)\napm = ElasticAPM(app)\n\n# ${s.i18n.translate("xpack.apm.tutorial.flaskClient.configure.commands.configureElasticApmComment",{defaultMessage:"Or use ELASTIC_APM in your application's settings"})}\nfrom elasticapm.contrib.flask import ElasticAPM\napp.config['ELASTIC_APM'] = {\n  '${b.apmServiceName}': '{{{apmServiceName}}}',\n\n  '${b.secretToken}': '{{{secretToken}}}',\n\n  '${b.apmServerUrl}': '{{{apmServerUrl}}}',\n\n  '${b.apmEnvironment}': '{{{apmEnvironment}}}',\n}\n\napm = ElasticAPM(app)`,j={apmServiceName:"service_name",secretToken:"secret_token",apmServerUrl:"server_url",apmEnvironment:"environment"},M={start:1,highlight:"3, 5, 7, 9",annotations:{3:`${c} ${s.i18n.translate("xpack.apm.tutorial.railsClient.createConfig.commands.defaultServiceName",{defaultMessage:"Defaults to the name of your Rails app."})}`,5:u,7:v,9:d}},O=`# config/elastic_apm.yml:\n\n${j.apmServiceName}: '{{{apmServiceName}}}'\n\n${j.secretToken}: '{{{secretToken}}}'\n\n${j.apmServerUrl}: '{{{apmServerUrl}}}'\n\n${j.apmEnvironment}: '{{{apmEnvironment}}}'`,U={apmServiceName:"service_name",secretToken:"secret_token",apmServerUrl:"server_url",apmEnvironment:"environment"},A={start:1,highlight:"3, 5, 7, 9",annotations:{3:`${c} ${s.i18n.translate("xpack.apm.tutorial.rackClient.createConfig.commands.defaultsToTheNameOfRackAppClassComment",{defaultMessage:"Defaults to the name of your Rack app's class."})}`,5:u,7:v,9:d}},$=`# config/elastic_apm.yml:\n\n${U.apmServiceName}: '{{{apmServiceName}}}'\n\n${U.secretToken}: '{{{secretToken}}}'\n\n${U.apmServerUrl}: '{{{apmServerUrl}}}',\n\n${U.apmEnvironment}: '{{{apmEnvironment}}}'`,C={apmServiceName:"ELASTIC_APM_SERVICE_NAME",secretToken:"ELASTIC_APM_SECRET_TOKEN",apmServerUrl:"ELASTIC_APM_SERVER_URL",apmEnvironment:"ELASTIC_APM_ENVIRONMENT"},R={start:1,highlight:"2, 4, 6, 8",annotations:{2:`${c} ${s.i18n.translate("xpack.apm.tutorial.goClient.configure.commands.usedExecutableNameComment",{defaultMessage:"If not specified, the executable name will be used."})}`,4:u,6:v,8:d}},I=`# ${s.i18n.translate("xpack.apm.tutorial.goClient.configure.commands.initializeUsingEnvironmentVariablesComment",{defaultMessage:"Initialize using environment variables:"})}\nexport ${C.apmServiceName}={{{apmServiceName}}}\n\nexport ${C.secretToken}={{{secretToken}}}\n\nexport ${C.apmServerUrl}={{{apmServerUrl}}}\n\nexport ${C.apmEnvironment}={{{apmEnvironment}}}\n`,L={apmServiceName:"ServiceName",secretToken:"SecretToken",apmServerUrl:"ServerUrl",apmEnvironment:"Environment"},P={start:1,highlight:"3, 4, 5, 6",annotations:{3:`${c} ${s.i18n.translate("xpack.apm.tutorial.dotnetClient.createConfig.commands.defaultServiceName",{defaultMessage:"Default is the entry assembly of the application."})}`,4:u,5:v,6:d}},D=`{\n  "ElasticApm": {\n    "${L.apmServiceName}": "{{{apmServiceName}}}",\n    "${L.secretToken}": "{{{secretToken}}}",\n    "${L.apmServerUrl}": "{{{apmServerUrl}}}",\n    "${L.apmEnvironment}": "{{{apmEnvironment}}}",\n  }\n}`,V={apmServiceName:"elastic_apm.service_name",secretToken:"elastic_apm.secret_token",apmServerUrl:"elastic_apm.server_url",apmEnvironment:"elastic_apm.environment"},w={start:1,highlight:"1, 3, 5, 7",annotations:{1:c,3:u,5:v,7:d}},z=`${V.apmServiceName}="{{{apmServiceName}}}"\n\n${V.secretToken}="{{{secretToken}}}"\n\n${V.apmServerUrl}="{{{apmServerUrl}}}"\n\n${V.apmEnvironment}="{{{apmEnvironment}}}"`,B={apmServiceName:"serviceName",apmServerUrl:"serverUrl",apmServiceVersion:"serviceVersion",apmEnvironment:"environment"},F=s.i18n.translate("xpack.apm.tutorial.jsClient.installDependency.commands.setServiceVersionComment",{defaultMessage:"Set the service version (required for source map feature)"}),H={java:f,node:h,django:x,flask:N,rails:O,rack:$,go:I,dotnet:D,php:z,js:`import { init as initApm } from '@elastic/apm-rum'\nvar apm = initApm({\n  ${B.apmServiceName}: '{{{apmServiceName}}}',\n\n  ${B.apmServerUrl}: '{{{apmServerUrl}}}',\n\n  serviceVersion: '',\n\n  ${B.apmEnvironment}: '{{{apmEnvironment}}}'\n})`,js_script:`<script src="https://your-cdn-host.com/path/to/elastic-apm-rum.umd.min.js" crossorigin><\/script>\n<script>\n  elasticApm.init({\n    ${B.apmServiceName}: '{{{apmServiceName}}}',\n    ${B.apmServerUrl}: '{{{apmServerUrl}}}',\n  })\n<\/script>\n`},X={java:g,node:S,django:k,flask:b,rails:j,rack:U,go:C,dotnet:L,php:V,js:B},q={java:E,node:T,django:_,flask:y,rails:M,rack:A,go:R,dotnet:P,php:w,js:{start:1,highlight:"3, 5, 7, 9",annotations:{3:c,5:v,7:F,9:d}}},G={java:"java",node:"js",django:"py",flask:"py",rails:"rb",rack:"rb",go:"go",dotnet:"dotnet",php:"php",js:"js"};var K=a(30770);function W({variables:e,data:n}){if(!e)return null;const a=[{field:"setting",name:s.i18n.translate("xpack.apm.tutorial.agent.column.configSettings",{defaultMessage:"Configuration setting"})},{field:"value",name:s.i18n.translate("xpack.apm.tutorial.agent.column.configValue",{defaultMessage:"Configuration value"}),render:(e,{value:n})=>(0,m.jsx)(i.EuiText,{size:"s",color:"accent"},n)}],t=Object.keys(e).map((a=>({setting:e[a],value:(0,K.get)(n,a)})));return(0,m.jsx)(i.EuiBasicTable,{items:t,columns:a})}function Z({variantId:e,apmServerUrl:n,secretToken:a}){const t={apmServiceName:"my-service-name",apmEnvironment:"my-environment"};if("openTelemetry"===e)return(0,m.jsx)(r().Fragment,null,(0,m.jsx)(i.EuiSpacer,null),(0,m.jsx)(l,{apmServerUrl:n,secretToken:a}));const o=function({variantId:e,policyDetails:n,defaultValues:a}){const t=H[e];return t?p.A.render(t,{...n,...a}):""}({variantId:e,policyDetails:{apmServerUrl:n,secretToken:a},defaultValues:t}),c=function(e){return X[e]}(e),u=function(e){return q[e]}(e),v=function(e){return G[e]}(e);return(0,m.jsx)(r().Fragment,null,(0,m.jsx)(i.EuiSpacer,null),(0,m.jsx)(W,{variables:c,data:{apmServerUrl:n,secretToken:a,...t}}),(0,m.jsx)(i.EuiSpacer,null),(0,m.jsx)(i.EuiCodeBlock,{isCopyable:!0,copyAriaLabel:s.i18n.translate("xpack.apm.tutorial.apmAgents.agentConfigurationInstructions.copyAriaLabel",{defaultMessage:"Copy {variantId} agent configuration code",values:{variantId:e}}),language:v||"bash","data-test-subj":"commands",lineNumbers:u},o))}},3185:(e,n,a)=>{e.exports=a(52497)(51858)}}]);