"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationSummaryItem = DurationSummaryItem;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _formatters = require("../../../../common/utils/formatters");
var _percent_of_parent = require("../../app/transaction_details/waterfall_with_summary/percent_of_parent");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DurationSummaryItem({
  duration,
  totalDuration,
  parentType
}) {
  const calculatedTotalDuration = totalDuration === undefined ? duration : totalDuration;
  const label = _i18n.i18n.translate('xpack.apm.transactionDurationLabel', {
    defaultMessage: 'Duration'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, (0, _formatters.asDuration)(duration), " \xA0", /*#__PURE__*/_react.default.createElement(_percent_of_parent.PercentOfParent, {
    duration: duration,
    totalDuration: calculatedTotalDuration,
    parentType: parentType
  }))));
}