"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutFooter = FlyoutFooter;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _delete_button = require("./delete_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlyoutFooter({
  onClose,
  isSaving,
  onDelete,
  customLinkId,
  isSaveButtonEnabled
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmCustomLinkFlyoutFooterCloseButton",
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.close', {
    defaultMessage: 'Close'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      display: 'block'
    }
  }, customLinkId && /*#__PURE__*/_react.default.createElement(_delete_button.DeleteButton, {
    customLinkId: customLinkId,
    onDelete: onDelete
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmCustomLinkFlyoutFooterSaveButton",
    form: "customLink_form",
    fill: true,
    type: "submit",
    isLoading: isSaving,
    isDisabled: !isSaveButtonEnabled
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.save', {
    defaultMessage: 'Save'
  })))));
}