"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateOnWeekDay = void 0;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateOnWeekDay = array => {
  if (array.length === 0) {
    return 'OnWeekDay cannot be empty';
  }
  const onWeekDayRegex = new RegExp(_constants.WEEKDAY_REGEX);
  const invalidDays = [];
  array.forEach(day => {
    if (!onWeekDayRegex.test(day)) {
      invalidDays.push(day);
    }
  });
  if (invalidDays.length > 0) {
    return `Invalid onWeekDay values in recurring schedule: ${invalidDays.join(',')}`;
  }
};
exports.validateOnWeekDay = validateOnWeekDay;