/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.elasticsearch.core.SuppressForbidden;

public class AssertingKnnVectorsReaderReflect {
    private static final Class<?> ASSERTING_ASSERT_KNN_READER_CLS = AssertingKnnVectorsReaderReflect.getAssertingReaderOrNull();
    private static final MethodHandle GET_VECTOR_INDEX_LENGTH_HANDLE = AssertingKnnVectorsReaderReflect.getDelegateFieldHandle();

    @SuppressForbidden(reason="static type is not accessible")
    public static KnnVectorsReader unwrapAssertingReader(KnnVectorsReader reader) {
        try {
            if (ASSERTING_ASSERT_KNN_READER_CLS != null && ASSERTING_ASSERT_KNN_READER_CLS.isAssignableFrom(reader.getClass())) {
                return GET_VECTOR_INDEX_LENGTH_HANDLE.invoke(reader);
            }
        }
        catch (Throwable t) {
            AssertingKnnVectorsReaderReflect.handleThrowable(t);
        }
        return reader;
    }

    private static Class<?> getAssertingReaderOrNull() {
        try {
            return Class.forName("org.apache.lucene.tests.codecs.asserting.AssertingKnnVectorsFormat$AssertingKnnVectorsReader");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static MethodHandle getDelegateFieldHandle() {
        try {
            Class<?> cls = AssertingKnnVectorsReaderReflect.getAssertingReaderOrNull();
            if (cls == null) {
                return MethodHandles.throwException(KnnVectorsReader.class, AssertionError.class);
            }
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(cls, MethodHandles.lookup());
            return lookup.findGetter(cls, "delegate", KnnVectorsReader.class);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static void handleThrowable(Throwable t) {
        if (t instanceof Error) {
            Error error = (Error)t;
            throw error;
        }
        if (t instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)t;
            throw runtimeException;
        }
        throw new AssertionError((Object)t);
    }
}

