/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.IllegalShardRoutingStateException;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RelocationFailureInfo;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class ShardRouting
implements Writeable,
ToXContentObject {
    public static final long UNAVAILABLE_EXPECTED_SHARD_SIZE = -1L;
    private static final TransportVersion EXPECTED_SHARD_SIZE_FOR_STARTED_VERSION = TransportVersions.V_8_5_0;
    private static final TransportVersion RELOCATION_FAILURE_INFO_VERSION = TransportVersions.V_8_6_0;
    private final ShardId shardId;
    private final String currentNodeId;
    @Nullable
    private final String relocatingNodeId;
    private final boolean primary;
    private final ShardRoutingState state;
    @Nullable
    private final RecoverySource recoverySource;
    @Nullable
    private final UnassignedInfo unassignedInfo;
    private final RelocationFailureInfo relocationFailureInfo;
    private final AllocationId allocationId;
    private final long expectedShardSize;
    @Nullable
    private final ShardRouting targetRelocatingShard;
    private final Role role;
    private int hashCode;

    ShardRouting(ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, RecoverySource recoverySource, UnassignedInfo unassignedInfo, RelocationFailureInfo relocationFailureInfo, AllocationId allocationId, long expectedShardSize, Role role) {
        this.shardId = shardId;
        this.currentNodeId = currentNodeId;
        this.relocatingNodeId = relocatingNodeId;
        this.primary = primary;
        this.state = state;
        this.recoverySource = recoverySource;
        this.unassignedInfo = unassignedInfo;
        this.relocationFailureInfo = relocationFailureInfo;
        this.allocationId = allocationId;
        this.expectedShardSize = expectedShardSize;
        this.role = role;
        this.targetRelocatingShard = this.initializeTargetRelocatingShard();
        assert (this.assertConsistent());
    }

    private boolean assertConsistent() {
        assert (this.relocationFailureInfo != null) : "relocation failure info must be always set";
        assert (this.role != null) : "role must be always set";
        assert (!this.primary || this.role.isPromotableToPrimary()) : "shard with unpromotable role was promoted to primary: " + String.valueOf(this);
        switch (this.state) {
            case UNASSIGNED: {
                assert (this.currentNodeId == null) : String.valueOf((Object)this.state) + " shard must not be assigned to a node " + String.valueOf(this);
                assert (this.relocatingNodeId == null) : String.valueOf((Object)this.state) + " shard must not be relocating to a node " + String.valueOf(this);
                assert (this.unassignedInfo != null) : String.valueOf((Object)this.state) + " shard must be created with unassigned info " + String.valueOf(this);
                assert (this.recoverySource != null) : String.valueOf((Object)this.state) + " shard must be created with a recovery source" + String.valueOf(this);
                assert (this.primary ^ this.recoverySource == RecoverySource.PeerRecoverySource.INSTANCE) : "replica shards always recover from primary" + String.valueOf(this);
                break;
            }
            case INITIALIZING: {
                assert (this.currentNodeId != null) : String.valueOf((Object)this.state) + " shard must be assigned to a node " + String.valueOf(this);
                assert (this.recoverySource != null) : String.valueOf((Object)this.state) + "shard must be created with a recovery source" + String.valueOf(this);
                assert (this.primary || this.recoverySource == RecoverySource.PeerRecoverySource.INSTANCE) : "replica shards always recover from primary" + String.valueOf(this);
                break;
            }
            case STARTED: {
                assert (this.currentNodeId != null) : String.valueOf((Object)this.state) + " shard must be assigned to a node " + String.valueOf(this);
                assert (this.relocatingNodeId == null) : String.valueOf((Object)this.state) + " shard must not be relocating to a node " + String.valueOf(this);
                assert (this.unassignedInfo == null) : String.valueOf((Object)this.state) + " shard must be created without unassigned info " + String.valueOf(this);
                assert (this.recoverySource == null) : String.valueOf((Object)this.state) + " shard must be created without a recovery source" + String.valueOf(this);
                break;
            }
            case RELOCATING: {
                assert (this.currentNodeId != null) : String.valueOf((Object)this.state) + " shard must be assigned to a node " + String.valueOf(this);
                assert (this.relocatingNodeId != null) : String.valueOf((Object)this.state) + " shard must be relocating to a node " + String.valueOf(this);
                assert (this.unassignedInfo == null) : String.valueOf((Object)this.state) + " shard must be created without unassigned info " + String.valueOf(this);
                assert (this.recoverySource == null) : String.valueOf((Object)this.state) + " shard must be created without a recovery source" + String.valueOf(this);
                break;
            }
        }
        return true;
    }

    @Nullable
    private ShardRouting initializeTargetRelocatingShard() {
        if (this.state == ShardRoutingState.RELOCATING) {
            return new ShardRouting(this.shardId, this.relocatingNodeId, this.currentNodeId, this.primary, ShardRoutingState.INITIALIZING, RecoverySource.PeerRecoverySource.INSTANCE, this.unassignedInfo, RelocationFailureInfo.NO_FAILURES, AllocationId.newTargetRelocation(this.allocationId), this.expectedShardSize, this.role);
        }
        return null;
    }

    public static ShardRouting newUnassigned(ShardId shardId, boolean primary, RecoverySource recoverySource, UnassignedInfo unassignedInfo, Role role) {
        return new ShardRouting(shardId, null, null, primary, ShardRoutingState.UNASSIGNED, recoverySource, unassignedInfo, RelocationFailureInfo.NO_FAILURES, null, -1L, role);
    }

    public Index index() {
        return this.shardId.getIndex();
    }

    public String getIndexName() {
        return this.shardId.getIndexName();
    }

    public int id() {
        return this.shardId.id();
    }

    public int getId() {
        return this.id();
    }

    public boolean unassigned() {
        return this.state == ShardRoutingState.UNASSIGNED;
    }

    public boolean initializing() {
        return this.state == ShardRoutingState.INITIALIZING;
    }

    public boolean active() {
        return this.started() || this.relocating();
    }

    public boolean started() {
        return this.state == ShardRoutingState.STARTED;
    }

    public boolean relocating() {
        return this.state == ShardRoutingState.RELOCATING;
    }

    public boolean assignedToNode() {
        return this.currentNodeId != null;
    }

    public String currentNodeId() {
        return this.currentNodeId;
    }

    public String relocatingNodeId() {
        return this.relocatingNodeId;
    }

    public ShardRouting getTargetRelocatingShard() {
        assert (this.relocating());
        return this.targetRelocatingShard;
    }

    @Nullable
    public UnassignedInfo unassignedInfo() {
        return this.unassignedInfo;
    }

    @Nullable
    public RelocationFailureInfo relocationFailureInfo() {
        return this.relocationFailureInfo;
    }

    @Nullable
    public AllocationId allocationId() {
        return this.allocationId;
    }

    public boolean primary() {
        return this.primary;
    }

    public ShardRoutingState state() {
        return this.state;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public ShardIterator shardsIt() {
        return new ShardIterator(this.shardId, List.of(this));
    }

    public ShardRouting(ShardId shardId, StreamInput in) throws IOException {
        this.shardId = shardId;
        this.currentNodeId = DiscoveryNode.deduplicateNodeIdentifier(in.readOptionalString());
        this.relocatingNodeId = DiscoveryNode.deduplicateNodeIdentifier(in.readOptionalString());
        this.primary = in.readBoolean();
        this.state = ShardRoutingState.fromValue(in.readByte());
        this.recoverySource = this.state == ShardRoutingState.UNASSIGNED || this.state == ShardRoutingState.INITIALIZING ? RecoverySource.readFrom(in) : null;
        this.unassignedInfo = in.readOptionalWriteable(UnassignedInfo::fromStreamInput);
        this.relocationFailureInfo = in.getTransportVersion().onOrAfter(RELOCATION_FAILURE_INFO_VERSION) ? RelocationFailureInfo.readFrom(in) : RelocationFailureInfo.NO_FAILURES;
        this.allocationId = in.readOptionalWriteable(AllocationId::new);
        this.expectedShardSize = this.state == ShardRoutingState.RELOCATING || this.state == ShardRoutingState.INITIALIZING || this.state == ShardRoutingState.STARTED && in.getTransportVersion().onOrAfter(EXPECTED_SHARD_SIZE_FOR_STARTED_VERSION) ? in.readLong() : -1L;
        this.role = in.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0) ? Role.readFrom(in) : Role.DEFAULT;
        this.targetRelocatingShard = this.initializeTargetRelocatingShard();
    }

    public ShardRouting(StreamInput in) throws IOException {
        this(new ShardId(in), in);
    }

    public void writeToThin(StreamOutput out) throws IOException {
        out.writeOptionalString(this.currentNodeId);
        out.writeOptionalString(this.relocatingNodeId);
        out.writeBoolean(this.primary);
        out.writeByte(this.state.value());
        if (this.state == ShardRoutingState.UNASSIGNED || this.state == ShardRoutingState.INITIALIZING) {
            this.recoverySource.writeTo(out);
        }
        out.writeOptionalWriteable(this.unassignedInfo);
        if (out.getTransportVersion().onOrAfter(RELOCATION_FAILURE_INFO_VERSION)) {
            this.relocationFailureInfo.writeTo(out);
        }
        out.writeOptionalWriteable(this.allocationId);
        if (this.state == ShardRoutingState.RELOCATING || this.state == ShardRoutingState.INITIALIZING || this.state == ShardRoutingState.STARTED && out.getTransportVersion().onOrAfter(EXPECTED_SHARD_SIZE_FOR_STARTED_VERSION)) {
            out.writeLong(this.expectedShardSize);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
            this.role.writeTo(out);
        } else if (this.role != Role.DEFAULT) {
            throw new IllegalStateException(Strings.format("cannot send role [%s] to node with version [%s]", this.role, out.getTransportVersion().toReleaseVersion()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        this.writeToThin(out);
    }

    public ShardRouting updateUnassigned(UnassignedInfo unassignedInfo, RecoverySource recoverySource) {
        assert (this.unassignedInfo != null) : "can only update unassigned info if it is already set";
        assert (this.unassignedInfo.delayed() || !unassignedInfo.delayed()) : "cannot transition from non-delayed to delayed";
        return new ShardRouting(this.shardId, this.currentNodeId, this.relocatingNodeId, this.primary, this.state, recoverySource, unassignedInfo, this.relocationFailureInfo, this.allocationId, this.expectedShardSize, this.role);
    }

    public ShardRouting updateRelocationFailure(RelocationFailureInfo relocationFailureInfo) {
        assert (this.relocationFailureInfo != null) : "can only update relocation failure info info if it is already set";
        return new ShardRouting(this.shardId, this.currentNodeId, this.relocatingNodeId, this.primary, this.state, this.recoverySource, this.unassignedInfo, relocationFailureInfo, this.allocationId, this.expectedShardSize, this.role);
    }

    public ShardRouting moveToUnassigned(UnassignedInfo unassignedInfo) {
        assert (this.state != ShardRoutingState.UNASSIGNED) : this;
        RecoverySource recoverySource = this.active() ? (this.primary() ? RecoverySource.ExistingStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE) : this.recoverySource();
        return new ShardRouting(this.shardId, null, null, this.primary, ShardRoutingState.UNASSIGNED, recoverySource, unassignedInfo, RelocationFailureInfo.NO_FAILURES, null, -1L, this.role);
    }

    public ShardRouting initialize(String nodeId, @Nullable String existingAllocationId, long expectedShardSize) {
        assert (this.state == ShardRoutingState.UNASSIGNED) : this;
        assert (this.relocatingNodeId == null) : this;
        AllocationId allocationId = existingAllocationId == null ? AllocationId.newInitializing() : AllocationId.newInitializing(existingAllocationId);
        return new ShardRouting(this.shardId, nodeId, null, this.primary, ShardRoutingState.INITIALIZING, this.recoverySource, this.unassignedInfo, RelocationFailureInfo.NO_FAILURES, allocationId, expectedShardSize, this.role);
    }

    public ShardRouting relocate(String relocatingNodeId, long expectedShardSize) {
        assert (this.state == ShardRoutingState.STARTED) : "current shard has to be started in order to be relocated " + String.valueOf(this);
        return new ShardRouting(this.shardId, this.currentNodeId, relocatingNodeId, this.primary, ShardRoutingState.RELOCATING, this.recoverySource, null, this.relocationFailureInfo, AllocationId.newRelocation(this.allocationId), expectedShardSize, this.role);
    }

    public ShardRouting cancelRelocation() {
        assert (this.state == ShardRoutingState.RELOCATING) : this;
        assert (this.assignedToNode()) : this;
        assert (this.relocatingNodeId != null) : this;
        return new ShardRouting(this.shardId, this.currentNodeId, null, this.primary, ShardRoutingState.STARTED, this.recoverySource, null, this.relocationFailureInfo.incFailedRelocations(), AllocationId.cancelRelocation(this.allocationId), -1L, this.role);
    }

    public ShardRouting removeRelocationSource() {
        assert (!this.primary) : this;
        assert (this.state == ShardRoutingState.INITIALIZING) : this;
        assert (this.assignedToNode()) : this;
        assert (this.relocatingNodeId != null) : this;
        return new ShardRouting(this.shardId, this.currentNodeId, null, this.primary, this.state, this.recoverySource, this.unassignedInfo, this.relocationFailureInfo, AllocationId.finishRelocation(this.allocationId), this.expectedShardSize, this.role);
    }

    public ShardRouting reinitializeReplicaShard() {
        assert (this.state == ShardRoutingState.INITIALIZING) : this;
        assert (!this.primary) : this;
        assert (!this.isRelocationTarget()) : this;
        return new ShardRouting(this.shardId, this.currentNodeId, null, this.primary, ShardRoutingState.INITIALIZING, this.recoverySource, this.unassignedInfo, this.relocationFailureInfo, AllocationId.newInitializing(), this.expectedShardSize, this.role);
    }

    public ShardRouting moveToStarted(long expectedShardSize) {
        assert (this.state == ShardRoutingState.INITIALIZING) : "expected an initializing shard " + String.valueOf(this);
        AllocationId allocationId = this.allocationId;
        if (allocationId.getRelocationId() != null) {
            allocationId = AllocationId.finishRelocation(allocationId);
        }
        return new ShardRouting(this.shardId, this.currentNodeId, null, this.primary, ShardRoutingState.STARTED, null, null, RelocationFailureInfo.NO_FAILURES, allocationId, expectedShardSize, this.role);
    }

    public ShardRouting moveActiveReplicaToPrimary() {
        assert (this.active()) : "expected an active shard " + String.valueOf(this);
        if (this.primary) {
            throw new IllegalShardRoutingStateException(this, "Already primary, can't move to primary");
        }
        return new ShardRouting(this.shardId, this.currentNodeId, this.relocatingNodeId, true, this.state, this.recoverySource, this.unassignedInfo, this.relocationFailureInfo, this.allocationId, this.expectedShardSize, this.role);
    }

    public ShardRouting moveUnassignedFromPrimary() {
        assert (this.state == ShardRoutingState.UNASSIGNED) : "expected an unassigned shard " + String.valueOf(this);
        if (!this.primary) {
            throw new IllegalShardRoutingStateException(this, "Not primary, can't move to replica");
        }
        return new ShardRouting(this.shardId, this.currentNodeId, this.relocatingNodeId, false, this.state, RecoverySource.PeerRecoverySource.INSTANCE, this.unassignedInfo, this.relocationFailureInfo, this.allocationId, this.expectedShardSize, this.role);
    }

    public boolean isSameAllocation(ShardRouting other) {
        boolean b;
        boolean bl = b = this.allocationId != null && other.allocationId != null && this.allocationId.getId().equals(other.allocationId.getId());
        assert (!b || this.currentNodeId.equals(other.currentNodeId)) : "ShardRoutings have the same allocation id but not the same node. This [" + String.valueOf(this) + "], other [" + String.valueOf(other) + "]";
        return b;
    }

    public boolean isRelocationTarget() {
        return this.state == ShardRoutingState.INITIALIZING && this.relocatingNodeId != null;
    }

    public boolean isRelocationTargetOf(ShardRouting other) {
        boolean b;
        boolean bl = b = this.allocationId != null && other.allocationId != null && this.state == ShardRoutingState.INITIALIZING && this.allocationId.getId().equals(other.allocationId.getRelocationId());
        assert (!b || other.state == ShardRoutingState.RELOCATING) : "ShardRouting is a relocation target but the source shard state isn't relocating. This [" + String.valueOf(this) + "], other [" + String.valueOf(other) + "]";
        assert (!b || other.allocationId.getId().equals(this.allocationId.getRelocationId())) : "ShardRouting is a relocation target but the source id isn't equal to source's allocationId.getRelocationId. This [" + String.valueOf(this) + "], other [" + String.valueOf(other) + "]";
        assert (!b || other.currentNodeId().equals(this.relocatingNodeId)) : "ShardRouting is a relocation target but source current node id isn't equal to target relocating node. This [" + String.valueOf(this) + "], other [" + String.valueOf(other) + "]";
        assert (!b || this.currentNodeId().equals(other.relocatingNodeId)) : "ShardRouting is a relocation target but current node id isn't equal to source relocating node. This [" + String.valueOf(this) + "], other [" + String.valueOf(other) + "]";
        assert (!b || this.shardId.equals(other.shardId)) : "ShardRouting is a relocation target but both indexRoutings are not of the same shard id. This [" + String.valueOf(this) + "], other [" + String.valueOf(other) + "]";
        assert (!b || this.primary == other.primary) : "ShardRouting is a relocation target but primary flag is different. This [" + String.valueOf(this) + "], target [" + String.valueOf(other) + "]";
        return b;
    }

    public boolean isRelocationSourceOf(ShardRouting other) {
        boolean b;
        boolean bl = b = this.allocationId != null && other.allocationId != null && other.state == ShardRoutingState.INITIALIZING && other.allocationId.getId().equals(this.allocationId.getRelocationId());
        assert (!b || this.state == ShardRoutingState.RELOCATING) : "ShardRouting is a relocation source but shard state isn't relocating. This [" + String.valueOf(this) + "], other [" + String.valueOf(other) + "]";
        assert (!b || this.allocationId.getId().equals(other.allocationId.getRelocationId())) : "ShardRouting is a relocation source but the allocation id isn't equal to other.allocationId.getRelocationId. This [" + String.valueOf(this) + "], other [" + String.valueOf(other) + "]";
        assert (!b || this.currentNodeId().equals(other.relocatingNodeId)) : "ShardRouting is a relocation source but current node isn't equal to other's relocating node. This [" + String.valueOf(this) + "], other [" + String.valueOf(other) + "]";
        assert (!b || other.currentNodeId().equals(this.relocatingNodeId)) : "ShardRouting is a relocation source but relocating node isn't equal to other's current node. This [" + String.valueOf(this) + "], other [" + String.valueOf(other) + "]";
        assert (!b || this.shardId.equals(other.shardId)) : "ShardRouting is a relocation source but both indexRoutings are not of the same shard. This [" + String.valueOf(this) + "], target [" + String.valueOf(other) + "]";
        assert (!b || this.primary == other.primary) : "ShardRouting is a relocation source but primary flag is different. This [" + String.valueOf(this) + "], target [" + String.valueOf(other) + "]";
        return b;
    }

    public boolean equalsIgnoringMetadata(ShardRouting other) {
        return this.primary == other.primary && this.shardId.equals(other.shardId) && Objects.equals(this.currentNodeId, other.currentNodeId) && Objects.equals(this.relocatingNodeId, other.relocatingNodeId) && Objects.equals(this.allocationId, other.allocationId) && this.state == other.state && Objects.equals(this.recoverySource, other.recoverySource) && this.role == other.role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardRouting that = (ShardRouting)o;
        return this.equalsIgnoringMetadata(that) && Objects.equals(this.unassignedInfo, that.unassignedInfo) && Objects.equals(this.relocationFailureInfo, that.relocationFailureInfo);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            h = this.shardId.hashCode();
            h = 31 * h + (this.currentNodeId != null ? this.currentNodeId.hashCode() : 0);
            h = 31 * h + (this.relocatingNodeId != null ? this.relocatingNodeId.hashCode() : 0);
            h = 31 * h + (this.primary ? 1 : 0);
            h = 31 * h + (this.state != null ? this.state.hashCode() : 0);
            h = 31 * h + (this.recoverySource != null ? this.recoverySource.hashCode() : 0);
            h = 31 * h + (this.allocationId != null ? this.allocationId.hashCode() : 0);
            h = 31 * h + (this.unassignedInfo != null ? this.unassignedInfo.hashCode() : 0);
            h = 31 * h + (this.relocationFailureInfo != null ? this.relocationFailureInfo.hashCode() : 0);
            this.hashCode = h = 31 * h + this.role.hashCode();
        }
        return h;
    }

    public String toString() {
        return this.shortSummary();
    }

    public String shortSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.shardId.getIndexName()).append(']').append('[').append(this.shardId.getId()).append(']');
        sb.append(", node[").append(this.currentNodeId).append("], ");
        if (this.relocatingNodeId != null) {
            sb.append("relocating [").append(this.relocatingNodeId).append("], ");
        }
        if (this.role != Role.DEFAULT) {
            sb.append("[").append(this.role).append("], ");
        }
        if (this.primary) {
            sb.append("[P]");
        } else {
            sb.append("[R]");
        }
        if (this.recoverySource != null) {
            sb.append(", recovery_source[").append(this.recoverySource).append("]");
        }
        sb.append(", s[").append((Object)this.state).append("]");
        if (this.allocationId != null) {
            sb.append(", a").append(this.allocationId);
        }
        if (this.unassignedInfo != null) {
            sb.append(", ").append(this.unassignedInfo);
        }
        sb.append(", ").append(this.relocationFailureInfo);
        if (this.expectedShardSize != -1L) {
            sb.append(", expected_shard_size[").append(this.expectedShardSize).append("]");
        }
        return sb.toString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("state", (Enum)this.state()).field("primary", this.primary()).field("node", this.currentNodeId()).field("relocating_node", this.relocatingNodeId()).field("shard", this.id()).field("index", this.getIndexName());
        if (this.expectedShardSize != -1L && this.state != ShardRoutingState.STARTED) {
            builder.field("expected_shard_size_in_bytes", this.expectedShardSize);
        }
        if (this.recoverySource != null) {
            builder.field("recovery_source", (ToXContent)this.recoverySource);
        }
        if (this.allocationId != null) {
            builder.field("allocation_id");
            this.allocationId.toXContent(builder, params);
        }
        if (this.unassignedInfo != null) {
            this.unassignedInfo.toXContent(builder, params);
        }
        this.relocationFailureInfo.toXContent(builder, params);
        this.role.toXContent(builder, params);
        return builder.endObject();
    }

    public long getExpectedShardSize() {
        return this.expectedShardSize;
    }

    @Nullable
    public RecoverySource recoverySource() {
        return this.recoverySource;
    }

    public Role role() {
        return this.role;
    }

    public boolean isPromotableToPrimary() {
        return this.role.isPromotableToPrimary();
    }

    public boolean isSearchable() {
        return this.role.isSearchable();
    }

    public static enum Role implements Writeable,
    ToXContentFragment
    {
        DEFAULT(0, true, true),
        INDEX_ONLY(1, true, false),
        SEARCH_ONLY(2, false, true);

        private final byte code;
        private final boolean promotable;
        private final boolean searchable;

        private Role(byte code, boolean promotable, boolean searchable) {
            this.code = code;
            this.promotable = promotable;
            this.searchable = searchable;
        }

        public boolean isPromotableToPrimary() {
            return this.promotable;
        }

        public boolean isSearchable() {
            return this.searchable;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this == DEFAULT ? builder : builder.field("role", this.toString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.code);
        }

        public static Role readFrom(StreamInput in) throws IOException {
            return switch (in.readByte()) {
                case 0 -> DEFAULT;
                case 1 -> INDEX_ONLY;
                case 2 -> SEARCH_ONLY;
                default -> throw new IllegalStateException("unknown role");
            };
        }
    }
}

