/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PaymentOption {
    ALL_UPFRONT("AllUpfront"),
    PARTIAL_UPFRONT("PartialUpfront"),
    NO_UPFRONT("NoUpfront"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PaymentOption> VALUE_MAP;
    private final String value;

    private PaymentOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PaymentOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PaymentOption> knownValues() {
        EnumSet<PaymentOption> knownValues = EnumSet.allOf(PaymentOption.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PaymentOption.class, PaymentOption::toString);
    }
}

