/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.icu;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RawCollationKey;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.plugin.analysis.icu.IndexableBinaryStringTools;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.XContentParser;

public class ICUCollationKeywordFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "icu_collation_keyword";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final int ignoreAbove;
    private final Collator collator;
    private final CollatorParams params;
    private final String nullValue;
    private final FieldType fieldType;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final String indexOptions;

    private static ICUCollationKeywordFieldMapper toType(FieldMapper in) {
        return (ICUCollationKeywordFieldMapper)in;
    }

    protected ICUCollationKeywordFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Collator collator, Builder builder) {
        super(simpleName, mappedFieldType, builderParams);
        assert (collator.isFrozen());
        this.fieldType = ICUCollationKeywordFieldMapper.freezeAndDeduplicateFieldType((FieldType)fieldType);
        this.params = builder.collatorParams();
        this.ignoreAbove = (Integer)builder.ignoreAbove.getValue();
        this.collator = collator;
        this.nullValue = (String)builder.nullValue.getValue();
        this.indexed = (Boolean)builder.indexed.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.indexOptions = (String)builder.indexOptions.getValue();
    }

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), Lucene.KEYWORD_ANALYZER);
    }

    public CollationFieldType fieldType() {
        return (CollationFieldType)super.fieldType();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName()).init(this);
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        String value = parser.currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : parser.textOrNull();
        if (value == null) {
            return;
        }
        if (value.length() > this.ignoreAbove) {
            context.addIgnoredField(this.fullPath());
            return;
        }
        RawCollationKey key = this.collator.getRawCollationKey(value, null);
        BytesRef binaryValue = new BytesRef(key.bytes, 0, key.size);
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            Field field = new Field(this.mappedFieldType.name(), binaryValue, (IndexableFieldType)this.fieldType);
            context.doc().add((IndexableField)field);
        }
        if (this.hasDocValues) {
            context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
        } else if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).indexed, (boolean)true);
        final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).hasDocValues, (boolean)true);
        final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).fieldType.stored(), (boolean)false);
        final FieldMapper.Parameter<String> indexOptions = TextParams.keywordIndexOptions(m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).indexOptions);
        final FieldMapper.Parameter<Boolean> hasNorms = TextParams.norms((boolean)false, m -> !ICUCollationKeywordFieldMapper.toType((FieldMapper)m).fieldType.omitNorms());
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final FieldMapper.Parameter<String> rules = FieldMapper.Parameter.stringParam((String)"rules", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).params.rules, null).acceptsNull();
        final FieldMapper.Parameter<String> language = FieldMapper.Parameter.stringParam((String)"language", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).params.language, null).acceptsNull();
        final FieldMapper.Parameter<String> country = FieldMapper.Parameter.stringParam((String)"country", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).params.country, null).acceptsNull();
        final FieldMapper.Parameter<String> variant = FieldMapper.Parameter.stringParam((String)"variant", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).params.variant, null).acceptsNull();
        final FieldMapper.Parameter<String> strength = FieldMapper.Parameter.stringParam((String)"strength", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).params.strength, null).acceptsNull();
        final FieldMapper.Parameter<String> decomposition = FieldMapper.Parameter.stringParam((String)"decomposition", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).params.decomposition, null).acceptsNull();
        final FieldMapper.Parameter<String> alternate = FieldMapper.Parameter.stringParam((String)"alternate", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).params.alternate, null).acceptsNull();
        final FieldMapper.Parameter<Boolean> caseLevel = FieldMapper.Parameter.boolParam((String)"case_level", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).params.caseLevel, (boolean)false);
        final FieldMapper.Parameter<String> caseFirst = FieldMapper.Parameter.stringParam((String)"case_first", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).params.caseFirst, null).acceptsNull();
        final FieldMapper.Parameter<Boolean> numeric = FieldMapper.Parameter.boolParam((String)"numeric", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).params.numeric, (boolean)false);
        final FieldMapper.Parameter<String> variableTop = FieldMapper.Parameter.stringParam((String)"variable_top", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).params.variableTop, null).acceptsNull();
        final FieldMapper.Parameter<Boolean> hiraganaQuaternaryMode = FieldMapper.Parameter.boolParam((String)"hiragana_quaternary_mode", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).params.hiraganaQuaternaryMode, (boolean)false).acceptsNull();
        final FieldMapper.Parameter<Integer> ignoreAbove = FieldMapper.Parameter.ignoreAboveParam(m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).ignoreAbove, (int)Integer.MAX_VALUE);
        final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam((String)"null_value", (boolean)false, m -> ICUCollationKeywordFieldMapper.toType((FieldMapper)m).nullValue, null).acceptsNull();

        public Builder(String name) {
            super(name);
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue((Object)nullValue);
            return this;
        }

        Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove.setValue((Object)ignoreAbove);
            return this;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.hasDocValues, this.stored, this.indexOptions, this.hasNorms, this.rules, this.language, this.country, this.variant, this.strength, this.decomposition, this.alternate, this.caseLevel, this.caseFirst, this.numeric, this.variableTop, this.hiraganaQuaternaryMode, this.ignoreAbove, this.nullValue, this.meta};
        }

        private CollatorParams collatorParams() {
            CollatorParams params = new CollatorParams();
            params.rules = (String)this.rules.getValue();
            params.language = (String)this.language.getValue();
            params.country = (String)this.country.getValue();
            params.variant = (String)this.variant.getValue();
            params.strength = (String)this.strength.getValue();
            params.decomposition = (String)this.decomposition.getValue();
            params.alternate = (String)this.alternate.getValue();
            params.caseLevel = (Boolean)this.caseLevel.getValue();
            params.caseFirst = (String)this.caseFirst.getValue();
            params.numeric = (Boolean)this.numeric.getValue();
            params.variableTop = (String)this.variableTop.getValue();
            params.hiraganaQuaternaryMode = (Boolean)this.hiraganaQuaternaryMode.getValue();
            return params;
        }

        private FieldType buildFieldType() {
            FieldType ft = new FieldType();
            ft.setTokenized(false);
            ft.setOmitNorms((Boolean)this.hasNorms.getValue() == false);
            ft.setIndexOptions(TextParams.toIndexOptions((boolean)((Boolean)this.indexed.getValue()), (String)((String)this.indexOptions.getValue())));
            ft.setStored(((Boolean)this.stored.getValue()).booleanValue());
            return ft;
        }

        public ICUCollationKeywordFieldMapper build(MapperBuilderContext context) {
            CollatorParams params = this.collatorParams();
            Collator collator = params.buildCollator();
            CollationFieldType ft = new CollationFieldType(context.buildFullName(this.leafName()), (Boolean)this.indexed.getValue(), (Boolean)this.stored.getValue(), (Boolean)this.hasDocValues.getValue(), collator, (String)this.nullValue.getValue(), (Integer)this.ignoreAbove.getValue(), (Map)this.meta.getValue());
            return new ICUCollationKeywordFieldMapper(this.leafName(), this.buildFieldType(), (MappedFieldType)ft, this.builderParams((Mapper.Builder)this, context), collator, this);
        }
    }

    private static class CollatorParams {
        private String rules;
        private String language;
        private String country;
        private String variant;
        private String strength;
        private String decomposition;
        private String alternate;
        private boolean caseLevel;
        private String caseFirst;
        private boolean numeric;
        private String variableTop;
        private boolean hiraganaQuaternaryMode;

        private CollatorParams() {
        }

        public Collator buildCollator() {
            Collator collator;
            if (this.rules != null) {
                try {
                    collator = new RuleBasedCollator(this.rules);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to parse collation rules", e);
                }
            } else if (this.language != null) {
                ULocale locale = this.country != null ? (this.variant != null ? new ULocale(this.language, this.country, this.variant) : new ULocale(this.language, this.country)) : new ULocale(this.language);
                collator = Collator.getInstance((ULocale)locale);
            } else {
                collator = Collator.getInstance((ULocale)ULocale.ROOT);
            }
            if (this.strength != null) {
                if (this.strength.equalsIgnoreCase("primary")) {
                    collator.setStrength(0);
                } else if (this.strength.equalsIgnoreCase("secondary")) {
                    collator.setStrength(1);
                } else if (this.strength.equalsIgnoreCase("tertiary")) {
                    collator.setStrength(2);
                } else if (this.strength.equalsIgnoreCase("quaternary")) {
                    collator.setStrength(3);
                } else if (this.strength.equalsIgnoreCase("identical")) {
                    collator.setStrength(15);
                } else {
                    throw new IllegalArgumentException("Invalid strength: " + this.strength);
                }
            }
            if (this.decomposition != null) {
                if (this.decomposition.equalsIgnoreCase("no")) {
                    collator.setDecomposition(16);
                } else if (this.decomposition.equalsIgnoreCase("canonical")) {
                    collator.setDecomposition(17);
                } else {
                    throw new IllegalArgumentException("Invalid decomposition: " + this.decomposition);
                }
            }
            RuleBasedCollator rbc = (RuleBasedCollator)collator;
            if (this.alternate != null) {
                if (this.alternate.equalsIgnoreCase("shifted")) {
                    rbc.setAlternateHandlingShifted(true);
                } else if (this.alternate.equalsIgnoreCase("non-ignorable")) {
                    rbc.setAlternateHandlingShifted(false);
                } else {
                    throw new IllegalArgumentException("Invalid alternate: " + this.alternate);
                }
            }
            if (this.caseLevel) {
                rbc.setCaseLevel(true);
            }
            if (this.caseFirst != null) {
                if (this.caseFirst.equalsIgnoreCase("lower")) {
                    rbc.setLowerCaseFirst(true);
                } else if (this.caseFirst.equalsIgnoreCase("upper")) {
                    rbc.setUpperCaseFirst(true);
                } else {
                    throw new IllegalArgumentException("Invalid caseFirst: " + this.caseFirst);
                }
            }
            if (this.numeric) {
                rbc.setNumericCollation(true);
            }
            if (this.variableTop != null) {
                rbc.setVariableTop(this.variableTop);
            }
            if (this.hiraganaQuaternaryMode) {
                rbc.setHiraganaQuaternary(true);
            }
            return collator.freeze();
        }
    }

    public static final class CollationFieldType
    extends StringFieldType {
        private final Collator collator;
        private final String nullValue;
        private final int ignoreAbove;
        public static final DocValueFormat COLLATE_FORMAT = new DocValueFormat(){

            public String getWriteableName() {
                return "collate";
            }

            public void writeTo(StreamOutput out) {
            }

            public String format(BytesRef value) {
                int encodedLength = IndexableBinaryStringTools.getEncodedLength(value.bytes, value.offset, value.length);
                char[] encoded = new char[encodedLength];
                IndexableBinaryStringTools.encode(value.bytes, value.offset, value.length, encoded, 0, encodedLength);
                return new String(encoded, 0, encodedLength);
            }

            public BytesRef parseBytesRef(Object value) {
                char[] encoded = value.toString().toCharArray();
                int decodedLength = IndexableBinaryStringTools.getDecodedLength(encoded, 0, encoded.length);
                byte[] decoded = new byte[decodedLength];
                IndexableBinaryStringTools.decode(encoded, 0, encoded.length, decoded, 0, decodedLength);
                return new BytesRef(decoded);
            }
        };

        public CollationFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, Collator collator, String nullValue, int ignoreAbove, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.collator = collator;
            this.nullValue = nullValue;
            this.ignoreAbove = ignoreAbove;
        }

        public CollationFieldType(String name, boolean searchable, Collator collator) {
            this(name, searchable, false, true, collator, null, Integer.MAX_VALUE, Collections.emptyMap());
        }

        public CollationFieldType(String name, Collator collator) {
            this(name, true, false, true, collator, null, Integer.MAX_VALUE, Collections.emptyMap());
        }

        public String typeName() {
            return ICUCollationKeywordFieldMapper.CONTENT_TYPE;
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                protected String parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    if (keywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    return keywordValue;
                }
            };
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, (dv, n) -> new DelegateDocValuesField((ScriptDocValues)new ScriptDocValues.Strings((ScriptDocValues.Supplier)new ScriptDocValues.StringsSupplier(FieldData.toString((SortedSetDocValues)dv))), n));
        }

        protected BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                BytesRef bytesRef = (BytesRef)value;
                value = bytesRef.utf8ToString();
            }
            if (this.collator != null) {
                RawCollationKey key = this.collator.getRawCollationKey(value.toString(), null);
                return new BytesRef(key.bytes, 0, key.size);
            }
            throw new IllegalStateException("collator is null");
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
            throw new UnsupportedOperationException("[fuzzy] queries are not supported on [icu_collation_keyword] fields.");
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            throw new UnsupportedOperationException("[prefix] queries are not supported on [icu_collation_keyword] fields.");
        }

        public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            throw new UnsupportedOperationException("[wildcard] queries are not supported on [icu_collation_keyword] fields.");
        }

        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            throw new UnsupportedOperationException("[regexp] queries are not supported on [icu_collation_keyword] fields.");
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return COLLATE_FORMAT;
        }
    }
}

