/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnectionReply;
import org.apache.derby.client.net.NetSqlca;

class NetPackageReply
extends NetConnectionReply {
    NetPackageReply(NetAgent netAgent, int bufferSize) {
        super(netAgent, bufferSize);
    }

    NetSqlca parseSqlErrorCondition() throws DisconnectException {
        this.parseSQLERRRM();
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        return netSqlca;
    }

    void parseDTAMCHRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8718);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, rdbnamReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.doDtamchrmSemantics();
    }

    protected void parseRDBUPDRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        this.parseLengthAndMatchCodePoint(8728);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_INFO);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, rdbnamReceived);
        this.netAgent_.setSvrcod(svrcod);
    }

    private void parseSQLERRRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8723);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived);
        this.netAgent_.setSvrcod(svrcod);
    }
}

