/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.serialize.SerializationParamsHandler;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class Serialize
extends SystemFunctionCall
implements Callable {
    int locationId = 0;

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public StringValue evaluateItem(XPathContext context) throws XPathException {
        return this.evalSerialize(this.argument[0].iterate(context), this.argument.length == 1 ? null : (NodeInfo)this.argument[1].evaluateItem(context), context);
    }

    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.evalSerialize(arguments[0].iterate(), arguments.length == 1 ? null : (NodeInfo)arguments[1].head(), context);
    }

    private StringValue evalSerialize(SequenceIterator iter, NodeInfo param, XPathContext context) throws XPathException {
        try {
            Item item;
            FastStringBuffer buffer = new FastStringBuffer(1024);
            boolean first = true;
            while ((item = iter.next()) != null) {
                if (!first) {
                    buffer.append(" ");
                } else {
                    first = false;
                }
                if (item instanceof NodeInfo) {
                    NodeInfo node = (NodeInfo)item;
                    if (node.getNodeKind() == 2 || node.getNodeKind() == 13) {
                        throw new XPathException("Attribute and namespace nodes cannot be serialized", "SENR0001");
                    }
                    Properties props = new Properties();
                    props.setProperty("method", "xml");
                    if (param != null) {
                        if (param.getNodeKind() != 1 || !"http://www.w3.org/2010/xslt-xquery-serialization".equals(param.getURI()) || !"serialization-parameters".equals(param.getLocalPart())) {
                            throw new XPathException("Second argument to fn:serialize() must be an element named {http://www.w3.org/2010/xslt-xquery-serialization}serialization-parameters", "XPTY0004");
                        }
                        SerializationParamsHandler sph = new SerializationParamsHandler();
                        sph.setLocator(this);
                        sph.setSerializationParams(param);
                        props = sph.getSerializationProperties();
                    }
                    try {
                        StringWriter result = new StringWriter();
                        XPathContextMinor c2 = context.newMinorContext();
                        SerializerFactory sf = context.getConfiguration().getSerializerFactory();
                        PipelineConfiguration pipe = context.getConfiguration().makePipelineConfiguration();
                        pipe.setController(context.getController());
                        Receiver receiver = sf.getReceiver(new StreamResult(result), pipe, props);
                        c2.changeOutputDestination(receiver, null);
                        SequenceReceiver out = c2.getReceiver();
                        out.open();
                        node.copy(out, 6, this.locationId);
                        out.close();
                        buffer.append(result.toString());
                        continue;
                    }
                    catch (Exception e) {
                        if (e instanceof XPathException) {
                            throw (XPathException)e;
                        }
                        XPathException se = new XPathException("Serialization unsuccessful", e);
                        se.setErrorCode("SEPM0016");
                        throw se;
                    }
                }
                if (item instanceof AtomicValue || item instanceof ObjectValue) {
                    buffer.append(item.getStringValue());
                    continue;
                }
                throw new XPathException("Function items cannot be serialized", "SENR0001");
            }
            return new StringValue(buffer.condense());
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }
}

