"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DocumentTrends;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _unifiedHistogram = require("@kbn/unified-histogram");
var _react2 = _interopRequireWildcard(require("react"));
var _translations = require("../../../../../common/translations");
var _hooks = require("../../../../hooks");
var _trend_docs_chart = require("./trend_docs_chart");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const trendDocsTooltip = /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.details.trendDocsTooltip",
  defaultMessage: "The percentage of ignored fields or failed docs over the selected timeframe."
});
const degradedDocsTooltip = /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.details.degradedDocsTooltip",
  defaultMessage: "The number of degraded documents \u2014documents with the {ignoredProperty} property\u2014 in your data set.",
  values: {
    ignoredProperty: /*#__PURE__*/_react2.default.createElement(_eui.EuiCode, {
      language: "json",
      transparentBackground: true
    }, "_ignored")
  }
});

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function DocumentTrends({
  lastReloadTime
}) {
  const {
    timeRange,
    updateTimeRange,
    docsTrendChart,
    canShowFailureStoreInfo
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    dataView,
    breakdown,
    redirectLinkProps,
    handleDocsTrendChartChange,
    ...qualityIssuesChartProps
  } = (0, _hooks.useQualityIssuesDocsChart)();
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: _translations.overviewTrendsDocsText
  });
  const onTimeRangeChange = (0, _react2.useCallback)(({
    start,
    end
  }) => {
    updateTimeRange({
      start,
      end,
      refreshInterval: timeRange.refresh.value
    });
  }, [updateTimeRange, timeRange.refresh]);
  const accordionTitle = !canShowFailureStoreInfo ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
        flex-direction: row;
        justify-content: flex-start;
        align-items: flex-start;
        gap: 4px;
      `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: 'xxs'
  }, /*#__PURE__*/_react2.default.createElement("h5", null, _translations.overviewPanelDatasetQualityIndicatorDegradedDocs)), /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: degradedDocsTooltip
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    size: "m",
    color: "subdued",
    type: "question",
    className: "eui-alignTop"
  }))) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
        flex-direction: row;
        justify-content: flex-start;
        align-items: flex-start;
        gap: 4px;
      `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: 'xxs'
  }, /*#__PURE__*/_react2.default.createElement("h5", null, _translations.overviewTrendsDocsText)), /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: trendDocsTooltip
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    size: "m",
    color: "subdued",
    type: "question",
    className: "eui-alignTop"
  })));
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: accordionTitle,
    paddingSize: "none",
    initialIsOpen: true,
    "data-test-subj": "datasetQualityDetailsOverviewDocumentTrends"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, canShowFailureStoreInfo && /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonGroup, {
    "data-test-subj": "datasetQualityDetailsChartTypeButtonGroup",
    legend: _i18n.i18n.translate('xpack.datasetQuality.details.chartTypeLegend', {
      defaultMessage: 'Quality chart type'
    }),
    onChange: id => handleDocsTrendChartChange(id),
    options: [{
      id: 'degraded',
      label: _i18n.i18n.translate('xpack.datasetQuality.details.chartType.degradedDocs', {
        defaultMessage: 'Ignored fields'
      })
    }, {
      id: 'failed',
      label: _i18n.i18n.translate('xpack.datasetQuality.details.chartType.failedDocs', {
        defaultMessage: 'Failed docs'
      })
    }],
    idSelected: docsTrendChart
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonRectangle, {
    width: 160,
    height: 32,
    isLoading: !dataView
  }, /*#__PURE__*/_react2.default.createElement(_unifiedHistogram.UnifiedBreakdownFieldSelector, {
    dataView: dataView,
    breakdown: {
      field: breakdown.dataViewField && breakdown.fieldSupportsBreakdown ? breakdown.dataViewField : undefined
    },
    onBreakdownFieldChange: breakdown.onChange
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: _translations.openInDiscoverText
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    display: "base",
    iconType: "discoverApp",
    "aria-label": _translations.discoverAriaText,
    size: "s",
    "data-test-subj": "datasetQualityDetailsLinkToDiscover"
  }, redirectLinkProps.linkProps)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_trend_docs_chart.TrendDocsChart, (0, _extends2.default)({}, qualityIssuesChartProps, {
    timeRange: timeRange,
    lastReloadTime: lastReloadTime,
    onTimeRangeChange: onTimeRangeChange
  }))));
}
module.exports = exports.default;