"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorNameAndDescriptionLogic = void 0;
var _kea = require("kea");
var _update_connector_name_and_description_api_logic = require("../../../../api/connector/update_connector_name_and_description_api_logic");
var _cached_fetch_index_api_logic = require("../../../../api/index/cached_fetch_index_api_logic");
var _indices = require("../../../../utils/indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorNameAndDescriptionLogic = exports.ConnectorNameAndDescriptionLogic = (0, _kea.kea)({
  key: props => props.http,
  actions: {
    saveNameAndDescription: true,
    setIsEditing: isEditing => ({
      isEditing
    }),
    setLocalNameAndDescription: nameAndDescription => nameAndDescription,
    setNameAndDescription: nameAndDescription => nameAndDescription,
    updateLocalNameAndDescription: nameAndDescription => nameAndDescription
  },
  connect: {
    actions: [_update_connector_name_and_description_api_logic.ConnectorNameAndDescriptionApiLogic, ['apiError', 'apiSuccess', 'makeRequest'], _cached_fetch_index_api_logic.CachedFetchIndexApiLogic, ['apiSuccess as fetchIndexApiSuccess']],
    values: [_cached_fetch_index_api_logic.CachedFetchIndexApiLogic, ['indexData as index']]
  },
  events: ({
    actions,
    values
  }) => ({
    afterMount: () => actions.setNameAndDescription((0, _indices.isConnectorIndex)(values.index) ? values.index.connector : {})
  }),
  listeners: ({
    actions,
    values,
    props
  }) => ({
    fetchIndexApiSuccess: index => {
      if (!values.isEditing && (0, _indices.isConnectorIndex)(index)) {
        actions.setNameAndDescription(index.connector);
      }
    },
    saveNameAndDescription: () => {
      if ((0, _indices.isConnectorIndex)(values.index)) {
        actions.makeRequest({
          connectorId: values.index.connector.id,
          ...values.localNameAndDescription,
          http: props.http
        });
      }
    },
    setIsEditing: isEditing => {
      if (isEditing) {
        actions.setLocalNameAndDescription(values.nameAndDescription);
      }
    }
  }),
  path: ['content_connectors', 'content', 'connector_name_and_description'],
  reducers: () => ({
    isEditing: [false, {
      apiSuccess: () => false,
      setIsEditing: (_, {
        isEditing
      }) => isEditing
    }],
    localNameAndDescription: [{}, {
      setLocalNameAndDescription: (_, nameAndDescription) => nameAndDescription,
      updateLocalNameAndDescription: (localNameAndDescription, nameAndDescription) => ({
        ...localNameAndDescription,
        ...nameAndDescription
      })
    }],
    nameAndDescription: [{}, {
      apiSuccess: (_, {
        description,
        name
      }) => ({
        description,
        name
      }),
      setNameAndDescription: (_, nameAndDescription) => nameAndDescription
    }]
  })
});