"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservableTypes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_context = require("../cases_context/use_cases_context");
var _observable_types_list = require("./observable_types_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ObservableTypesComponent = ({
  disabled,
  isLoading,
  handleAddObservableType,
  handleDeleteObservableType,
  handleEditObservableType,
  observableTypes
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const canModifyObservableTypes = !disabled && permissions.settings;
  const onAddObservableType = (0, _react.useCallback)(() => {
    handleAddObservableType();
  }, [handleAddObservableType]);
  const onEditObservableType = (0, _react.useCallback)(key => {
    handleEditObservableType(key);
  }, [handleEditObservableType]);
  if (!permissions.settings) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("h2", null, i18n.TITLE))),
    description: /*#__PURE__*/_react.default.createElement("p", null, i18n.DESCRIPTION),
    "data-test-subj": "observable-types-form-group"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    color: "subdued",
    hasBorder: false,
    hasShadow: false
  }, observableTypes.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_observable_types_list.ObservableTypesList, {
    disabled: !canModifyObservableTypes,
    observableTypes: observableTypes,
    onDeleteObservableType: handleDeleteObservableType,
    onEditObservableType: onEditObservableType
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), !observableTypes.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "empty-observable-types"
  }, i18n.NO_OBSERVABLE_TYPES, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, observableTypes.length < _constants.MAX_CUSTOM_OBSERVABLE_TYPES ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: isLoading,
    isDisabled: !canModifyObservableTypes,
    size: "s",
    onClick: onAddObservableType,
    iconType: "plusInCircle",
    "data-test-subj": "add-observable-type"
  }, i18n.ADD_OBSERVABLE_TYPE) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.MAX_OBSERVABLE_TYPES_LIMIT(_constants.MAX_CUSTOM_OBSERVABLE_TYPES)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })));
};
ObservableTypesComponent.displayName = 'CustomFields';
const ObservableTypes = exports.ObservableTypes = /*#__PURE__*/_react.default.memo(ObservableTypesComponent);