"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFitZoomScale = void 0;
var _lib = require("../../../../../common/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFitZoomScale = (boundingBox, workpadWidth, workpadHeight) => {
  const canvasLayoutContent = document.querySelector(`#${_lib.CANVAS_LAYOUT_STAGE_CONTENT_SELECTOR}`);
  const layoutWidth = canvasLayoutContent.clientWidth;
  const layoutHeight = canvasLayoutContent.clientHeight;
  const offsetLeft = boundingBox.left;
  const offsetTop = boundingBox.top;
  const offsetRight = boundingBox.right - workpadWidth;
  const offsetBottom = boundingBox.bottom - workpadHeight;
  const boundingWidth = workpadWidth + Math.max(Math.abs(offsetLeft), Math.abs(offsetRight)) * 2 + _lib.WORKPAD_CANVAS_BUFFER;
  const boundingHeight = workpadHeight + Math.max(Math.abs(offsetTop), Math.abs(offsetBottom)) * 2 + _lib.WORKPAD_CANVAS_BUFFER;
  const xScale = layoutWidth / boundingWidth;
  const yScale = layoutHeight / boundingHeight;
  return Math.min(xScale, yScale);
};
exports.getFitZoomScale = getFitZoomScale;