"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidebarContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sidebar_header = require("../../sidebar_header");
var _multi_element_settings = require("../multi_element_settings");
var _group_settings = require("../group_settings");
var _global_config = require("../global_config");
var _element_settings = require("../element_settings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getGroupedElementSidebarTitle: () => _i18n.i18n.translate('xpack.canvas.sidebarContent.groupedElementSidebarTitle', {
    defaultMessage: 'Grouped element',
    description: 'The title displayed when a grouped element is selected. "elements" refer to the different visualizations, images, ' + 'text, etc that can be added in a Canvas workpad. These elements can be grouped into a larger "grouped element" ' + 'that contains multiple individual elements.'
  }),
  getMultiElementSidebarTitle: () => _i18n.i18n.translate('xpack.canvas.sidebarContent.multiElementSidebarTitle', {
    defaultMessage: 'Multiple elements',
    description: 'The title displayed when multiple elements are selected. "elements" refer to the different visualizations, images, ' + 'text, etc that can be added in a Canvas workpad.'
  }),
  getSingleElementSidebarTitle: () => _i18n.i18n.translate('xpack.canvas.sidebarContent.singleElementSidebarTitle', {
    defaultMessage: 'Selected element',
    description: 'The title displayed when a single element are selected. "element" refer to the different visualizations, images, ' + 'text, etc that can be added in a Canvas workpad.'
  })
};
const MultiElementSidebar = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
  title: strings.getMultiElementSidebarTitle()
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_multi_element_settings.MultiElementSettings, null));
const GroupedElementSidebar = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
  title: strings.getGroupedElementSidebarTitle()
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_group_settings.GroupSettings, null));
const SingleElementSidebar = ({
  selectedElementId
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
  title: strings.getSingleElementSidebarTitle(),
  showLayerControls: true
}), /*#__PURE__*/_react.default.createElement(_element_settings.ElementSettings, {
  selectedElementId: selectedElementId
}));
const SidebarContent = ({
  selectedToplevelNodes,
  selectedElementId
}) => {
  if (selectedToplevelNodes.length > 1) {
    return /*#__PURE__*/_react.default.createElement(MultiElementSidebar, null);
  }
  if (selectedToplevelNodes.length === 1 && selectedToplevelNodes[0].includes('group')) {
    return /*#__PURE__*/_react.default.createElement(GroupedElementSidebar, null);
  }
  if (selectedToplevelNodes.length === 1) {
    return /*#__PURE__*/_react.default.createElement(SingleElementSidebar, {
      selectedElementId: selectedElementId
    });
  }
  return /*#__PURE__*/_react.default.createElement(_global_config.GlobalConfig, null);
};
exports.SidebarContent = SidebarContent;