"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartPointerEventContext = useChartPointerEventContext;
var _react = _interopRequireWildcard(require("react"));
var _chart_pointer_event_context = require("./chart_pointer_event_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useChartPointerEventContext() {
  const context = (0, _react.useContext)(_chart_pointer_event_context.ChartPointerEventContext);
  if (!context) {
    throw new Error('Missing ChartPointerEventContext provider');
  }
  const {
    pointerEventTargetRef
  } = context;
  const chartRef = /*#__PURE__*/_react.default.createRef();
  const requestIdRef = (0, _react.useRef)(0);
  const updatePointerEventHandler = (0, _react.useCallback)(event => {
    cancelAnimationFrame(requestIdRef.current);
    requestIdRef.current = requestAnimationFrame(() => {
      const pointerEvent = event instanceof CustomEvent ? event.detail : null;
      if (chartRef.current && pointerEvent) {
        chartRef.current.dispatchExternalPointerEvent(pointerEvent);
      }
    });
  }, [chartRef]);
  (0, _react.useEffect)(() => {
    const pointerEventTarget = pointerEventTargetRef.current;
    pointerEventTarget.addEventListener(_chart_pointer_event_context.UPDATE_POINTER_EVENT, updatePointerEventHandler);
    return () => {
      pointerEventTarget.removeEventListener(_chart_pointer_event_context.UPDATE_POINTER_EVENT, updatePointerEventHandler);
    };
  }, [updatePointerEventHandler, pointerEventTargetRef]);
  return {
    ...context,
    chartRef
  };
}