"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverMainRoute = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-utils-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _use_discover_services = require("../../hooks/use_discover_services");
var _redux = require("./state_management/redux");
var _context_awareness = require("../../context_awareness");
var _error_alert = require("../../components/common/error_alert");
var _session_view = require("./components/session_view");
var _use_async_function = require("./hooks/use_async_function");
var _tabs_view = require("./components/tabs_view");
var _constants = require("../../constants");
var _chart = require("./components/chart");
var _use_state_managers = require("./state_management/hooks/use_state_managers");
var _get_user_and_space_ids = require("./utils/get_user_and_space_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultCustomizationCallbacks = [];
const DiscoverMainRoute = ({
  customizationContext,
  customizationCallbacks = defaultCustomizationCallbacks,
  stateStorageContainer
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const rootProfileState = (0, _context_awareness.useRootProfile)();
  const history = (0, _reactRouterDom.useHistory)();
  const [urlStateStorage] = (0, _react.useState)(() => stateStorageContainer !== null && stateStorageContainer !== void 0 ? stateStorageContainer : (0, _public.createKbnUrlStateStorage)({
    useHash: services.uiSettings.get('state:storeInSessionStorage'),
    history,
    useHashQuery: customizationContext.displayMode !== 'embedded',
    ...(0, _public.withNotifyOnErrors)(services.core.notifications.toasts)
  }));
  const {
    internalState,
    runtimeStateManager
  } = (0, _use_state_managers.useStateManagers)({
    services,
    urlStateStorage,
    customizationContext
  });
  const {
    initializeProfileDataViews
  } = (0, _context_awareness.useDefaultAdHocDataViews)({
    internalState
  });
  const [mainRouteInitializationState, initializeMainRoute] = (0, _use_async_function.useAsyncFunction)(async loadedRootProfileState => {
    const {
      dataViews
    } = services;
    const [hasESData, hasUserDataView, defaultDataViewExists, userAndSpaceIds] = await Promise.all([dataViews.hasData.hasESData().catch(() => false), dataViews.hasData.hasUserDataView().catch(() => false), dataViews.defaultDataViewExists().catch(() => false), (0, _get_user_and_space_ids.getUserAndSpaceIds)(services), internalState.dispatch(_redux.internalStateActions.loadDataViewList()).catch(() => {}), initializeProfileDataViews(loadedRootProfileState).catch(() => {})]);
    internalState.dispatch(_redux.internalStateActions.initializeTabs(userAndSpaceIds));
    const initializationState = {
      hasESData,
      hasUserDataView: hasUserDataView && defaultDataViewExists
    };
    internalState.dispatch(_redux.internalStateActions.setInitializationState(initializationState));
    return initializationState;
  });
  (0, _react.useEffect)(() => {
    if (!rootProfileState.rootProfileLoading) {
      initializeMainRoute(rootProfileState);
    }
  }, [initializeMainRoute, rootProfileState]);
  (0, _useUnmount.default)(() => {
    for (const tabId of Object.keys(runtimeStateManager.tabs.byId)) {
      internalState.dispatch(_redux.internalStateActions.disconnectTab({
        tabId
      }));
    }
  });
  if (rootProfileState.rootProfileLoading || mainRouteInitializationState.loading) {
    return /*#__PURE__*/_react.default.createElement(_session_view.BrandedLoadingIndicator, null);
  }
  if (mainRouteInitializationState.error) {
    return /*#__PURE__*/_react.default.createElement(_error_alert.DiscoverError, {
      error: mainRouteInitializationState.error
    });
  }
  if (!mainRouteInitializationState.value.hasESData && !mainRouteInitializationState.value.hasUserDataView) {
    return /*#__PURE__*/_react.default.createElement(_session_view.NoDataPage, (0, _extends2.default)({}, mainRouteInitializationState.value, {
      onDataViewCreated: () => {
        // This is unused if there is no ES data
      }
    }));
  }
  const sessionViewProps = {
    customizationContext,
    customizationCallbacks,
    urlStateStorage,
    internalState,
    runtimeStateManager
  };
  return /*#__PURE__*/_react.default.createElement(_redux.InternalStateProvider, {
    store: internalState
  }, /*#__PURE__*/_react.default.createElement(rootProfileState.AppWrapper, null, /*#__PURE__*/_react.default.createElement(_chart.ChartPortalsRenderer, {
    runtimeStateManager: sessionViewProps.runtimeStateManager
  }, _constants.TABS_ENABLED ? /*#__PURE__*/_react.default.createElement(_tabs_view.TabsView, sessionViewProps) : /*#__PURE__*/_react.default.createElement(_session_view.DiscoverSessionView, sessionViewProps))));
};
exports.DiscoverMainRoute = DiscoverMainRoute;