"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sectionSchema = exports.sectionGridDataSchema = exports.gridDataSchema = exports.dashboardAttributesSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("../v2");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// sections only include y + i for grid data
const sectionGridDataSchema = exports.sectionGridDataSchema = _configSchema.schema.object({
  y: _configSchema.schema.number(),
  i: _configSchema.schema.string()
});

// panels include all grid data keys, including those that sections use
const gridDataSchema = exports.gridDataSchema = sectionGridDataSchema.extends({
  x: _configSchema.schema.number(),
  w: _configSchema.schema.number(),
  h: _configSchema.schema.number(),
  sectionId: _configSchema.schema.maybe(_configSchema.schema.string())
});
const sectionSchema = exports.sectionSchema = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  collapsed: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  gridData: sectionGridDataSchema
});
const dashboardAttributesSchema = exports.dashboardAttributesSchema = _v.dashboardAttributesSchema.extends({
  sections: _configSchema.schema.maybe(_configSchema.schema.arrayOf(sectionSchema))
}, {
  unknowns: 'ignore'
});