"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.highlightAnimationDuration = void 0;
exports.initializeTrackPanel = initializeTrackPanel;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const highlightAnimationDuration = exports.highlightAnimationDuration = 2000;
function initializeTrackPanel(untilLoaded) {
  const expandedPanelId$ = new _rxjs.BehaviorSubject(undefined);
  const focusedPanelId$ = new _rxjs.BehaviorSubject(undefined);
  const highlightPanelId$ = new _rxjs.BehaviorSubject(undefined);
  const scrollToPanelId$ = new _rxjs.BehaviorSubject(undefined);
  const scrollToBottom$ = new _rxjs.Subject();
  let scrollPosition;
  function setScrollToPanelId(id) {
    if (scrollToPanelId$.value !== id) scrollToPanelId$.next(id);
  }
  function setExpandedPanelId(id) {
    if (expandedPanelId$.value !== id) expandedPanelId$.next(id);
  }
  return {
    expandedPanelId$,
    expandPanel: panelId => {
      const isPanelExpanded = panelId === expandedPanelId$.value;
      if (isPanelExpanded) {
        setExpandedPanelId(undefined);
        setScrollToPanelId(panelId);
        return;
      }
      setExpandedPanelId(panelId);
      scrollPosition = window.scrollY;
    },
    focusedPanelId$,
    highlightPanelId$,
    highlightPanel: panelRef => {
      const id = highlightPanelId$.value;
      if (id && panelRef) {
        untilLoaded(id).then(() => {
          // Adds the highlight class in the next event loop to allow the DOM to update
          setTimeout(() => panelRef.classList.add('dshDashboardGrid__item--highlighted'), 0);
          // Removes the class after the highlight animation finishes
          setTimeout(() => {
            panelRef.classList.remove('dshDashboardGrid__item--highlighted');
          }, highlightAnimationDuration);
        });
      }
      highlightPanelId$.next(undefined);
    },
    scrollToPanelId$,
    scrollToPanel: async panelRef => {
      const id = scrollToPanelId$.value;
      if (!id) return;
      untilLoaded(id).then(() => {
        setScrollToPanelId(undefined);
        if (scrollPosition !== undefined) {
          window.scrollTo({
            top: scrollPosition,
            behavior: 'smooth'
          });
          scrollPosition = undefined;
        } else {
          panelRef.scrollIntoView({
            block: 'start',
            behavior: 'smooth'
          });
        }
      });
    },
    scrollToTop: () => {
      window.scrollTo({
        top: 0,
        behavior: 'smooth'
      });
    },
    scrollToBottom$,
    scrollToBottom: () => {
      window.scrollTo({
        top: document.body.scrollHeight,
        behavior: 'smooth'
      });
    },
    setFocusedPanelId: id => {
      if (focusedPanelId$.value !== id) focusedPanelId$.next(id);
      setScrollToPanelId(id);
    },
    setHighlightPanelId: id => {
      if (highlightPanelId$.value !== id) highlightPanelId$.next(id);
    },
    setScrollToPanelId
  };
}