"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _crud = require("./crud");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ContentType {
  constructor(definition, eventBus) {
    /** Content definition. */
    (0, _defineProperty2.default)(this, "_definition", void 0);
    /** Content crud instance. */
    (0, _defineProperty2.default)(this, "contentCrud", void 0);
    this._definition = definition;
    this.contentCrud = new _crud.ContentCrud(definition.id, definition.storage, {
      eventBus
    });
  }
  get id() {
    return this._definition.id;
  }
  get definition() {
    return this._definition;
  }
  get storage() {
    return this._definition.storage;
  }
  get crud() {
    return this.contentCrud;
  }
  get version() {
    return this._definition.version;
  }
}
exports.ContentType = ContentType;