"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EksCredentialsForm = exports.DEFAULT_EKS_VARS_GROUP = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _csp_boxed_radio_group = require("./csp_boxed_radio_group");
var _utils = require("./utils");
var _aws_input_var_fields = require("./aws_credentials_form/aws_input_var_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AWSSetupInfoContent = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
  margin: "xl"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.setupInfoContentTitle",
  defaultMessage: "Setup Access"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.setupInfoContent",
  defaultMessage: "The integration will need elevated access to run some CIS benchmark rules. Select your preferred method of providing the AWS credentials this integration will use. You can follow these step-by-step instructions to generate the necessary credentials."
})));
const DocsLink = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.docsLink",
  defaultMessage: "Read the {docs} for more details",
  values: {
    docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html",
      external: true
    }, "documentation")
  }
}));
const AssumeRoleDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.assumeRoleDescription",
  defaultMessage: "An IAM role Amazon Resource Name (ARN) is an IAM identity that you can create in your AWS account. When creating an IAM role, users can define the role\u2019s permissions. Roles do not have standard long-term credentials such as passwords or access keys."
})));
const DirectAccessKeysDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.directAccessKeysDescription",
  defaultMessage: "Access keys are long-term credentials for an IAM user or the AWS account root user."
})));
const TemporaryKeysDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.temporaryKeysDescription",
  defaultMessage: "You can configure temporary security credentials in AWS to last for a specified duration. They consist of an access key ID, a secret access key, and a security token, which is typically found using GetSessionToken."
})));
const SharedCredentialsDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.sharedCredentialsDescription",
  defaultMessage: "If you use different AWS credentials for different tools or applications, you can use profiles to define multiple access keys in the same configuration file."
})));
const AWS_FIELD_LABEL = {
  access_key_id: _i18n.i18n.translate('xpack.csp.eksIntegration.accessKeyIdLabel', {
    defaultMessage: 'Access Key ID'
  }),
  secret_access_key: _i18n.i18n.translate('xpack.csp.eksIntegration.secretAccessKeyLabel', {
    defaultMessage: 'Secret Access Key'
  })
};
const options = {
  assume_role: {
    label: _i18n.i18n.translate('xpack.csp.eksIntegration.assumeRoleLabel', {
      defaultMessage: 'Assume role'
    }),
    info: AssumeRoleDescription,
    fields: {
      role_arn: {
        label: _i18n.i18n.translate('xpack.csp.eksIntegration.roleArnLabel', {
          defaultMessage: 'Role ARN'
        }),
        dataTestSubj: 'roleArnInput'
      }
    },
    testId: 'assumeRoleTestId'
  },
  direct_access_keys: {
    label: _i18n.i18n.translate('xpack.csp.eksIntegration.directAccessKeyLabel', {
      defaultMessage: 'Direct access keys'
    }),
    info: DirectAccessKeysDescription,
    fields: {
      access_key_id: {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'directAccessKeyId'
      },
      secret_access_key: {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'directAccessSecretKey',
        isSecret: true
      }
    },
    testId: 'directAccessKeyTestId'
  },
  temporary_keys: {
    info: TemporaryKeysDescription,
    label: _i18n.i18n.translate('xpack.csp.eksIntegration.temporaryKeysLabel', {
      defaultMessage: 'Temporary keys'
    }),
    fields: {
      access_key_id: {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'temporaryKeysAccessKeyId'
      },
      secret_access_key: {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'temporaryKeysSecretAccessKey',
        isSecret: true
      },
      session_token: {
        label: _i18n.i18n.translate('xpack.csp.eksIntegration.sessionTokenLabel', {
          defaultMessage: 'Session Token'
        }),
        dataTestSubj: 'temporaryKeysSessionToken'
      }
    },
    testId: 'temporaryKeyTestId'
  },
  shared_credentials: {
    label: _i18n.i18n.translate('xpack.csp.eksIntegration.sharedCredentialLabel', {
      defaultMessage: 'Shared credentials'
    }),
    info: SharedCredentialsDescription,
    fields: {
      shared_credential_file: {
        label: _i18n.i18n.translate('xpack.csp.eksIntegration.sharedCredentialFileLabel', {
          defaultMessage: 'Shared Credential File'
        }),
        dataTestSubj: 'sharedCredentialFile'
      },
      credential_profile_name: {
        label: _i18n.i18n.translate('xpack.csp.eksIntegration.credentialProfileNameLabel', {
          defaultMessage: 'Credential Profile Name'
        }),
        dataTestSubj: 'credentialProfileName'
      }
    },
    testId: 'sharedCredentialsTestId'
  }
};
const DEFAULT_EKS_VARS_GROUP = exports.DEFAULT_EKS_VARS_GROUP = 'assume_role';
const AWS_CREDENTIALS_OPTIONS = Object.keys(options).map(value => ({
  id: value,
  label: options[value].label,
  testId: options[value].testId
}));
const getInputVarsFields = (input, fields) => Object.entries(input.streams[0].vars || {}).filter(([id]) => id in fields).map(([id, inputVar]) => {
  const field = fields[id];
  return {
    id,
    label: field.label,
    type: field.type || 'text',
    dataTestSubj: field.dataTestSubj,
    value: inputVar.value,
    isSecret: field === null || field === void 0 ? void 0 : field.isSecret
  };
});
const getAwsCredentialsType = input => {
  var _input$streams$0$vars;
  return (_input$streams$0$vars = input.streams[0].vars) === null || _input$streams$0$vars === void 0 ? void 0 : _input$streams$0$vars['aws.credentials.type'].value;
};
const EksCredentialsForm = ({
  input,
  newPolicy,
  packageInfo,
  updatePolicy
}) => {
  // We only have a value for 'aws.credentials.type' once the form has mounted.
  // On initial render we don't have that value so we default to the first option.
  const awsCredentialsType = getAwsCredentialsType(input) || AWS_CREDENTIALS_OPTIONS[0].id;
  const group = options[awsCredentialsType];
  const fields = getInputVarsFields(input, group.fields);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AWSSetupInfoContent, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(AwsCredentialTypeSelector, {
    type: awsCredentialsType,
    onChange: optionId => updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
      'aws.credentials.type': {
        value: optionId
      }
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), group.info, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), DocsLink, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_aws_input_var_fields.AwsInputVarFields, {
    fields: fields,
    packageInfo: packageInfo,
    onChange: (key, value) => updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
      [key]: {
        value
      }
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.EksCredentialsForm = EksCredentialsForm;
const AwsCredentialTypeSelector = ({
  type,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_csp_boxed_radio_group.RadioGroup, {
  size: "s",
  options: [...AWS_CREDENTIALS_OPTIONS],
  idSelected: type,
  onChange: id => onChange(id),
  name: "awsCredentialType"
});