"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSuggestUserProfiles = void 0;
var _react = require("react");
var _reactQuery = require("@kbn/react-query");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _lodash = require("lodash");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("../translations"));
var _kibana = require("../../common/lib/kibana");
var _constants2 = require("../constants");
var _api = require("./api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Time in ms until the data become stale.
 * We set the stale time to one minute
 * to prevent fetching the same queries
 * while the user is typing.
 */

const STALE_TIME = 1000 * 60;
const useSuggestUserProfiles = ({
  name,
  owners,
  size = _constants.DEFAULT_USER_SIZE,
  onDebounce = _lodash.noop
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const [debouncedName, setDebouncedName] = (0, _react.useState)(name);
  (0, _useDebounce.default)(() => {
    setDebouncedName(name);
    onDebounce();
  }, _constants.SEARCH_DEBOUNCE_MS, [name]);
  const toasts = (0, _kibana.useToasts)();
  return (0, _reactQuery.useQuery)(_constants2.casesQueriesKeys.suggestUsers({
    name: debouncedName,
    owners,
    size
  }), ({
    signal
  }) => (0, _api.suggestUserProfiles)({
    http,
    name: debouncedName,
    owners,
    size,
    signal
  }), {
    retry: false,
    keepPreviousData: true,
    staleTime: STALE_TIME,
    onError: error => {
      if (error.name !== 'AbortError') {
        toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: i18n.ERROR_TITLE
        });
      }
    }
  });
};
exports.useSuggestUserProfiles = useSuggestUserProfiles;