"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDownloadWorkpad = void 0;
var _react = require("react");
var _fileSaver = _interopRequireDefault(require("file-saver"));
var _i18n = require("@kbn/i18n");
var _canvas_workpad_service = require("../../../services/canvas_workpad_service");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getDownloadFailureErrorMessage: () => _i18n.i18n.translate('xpack.canvas.error.downloadWorkpad.downloadFailureErrorMessage', {
    defaultMessage: "Couldn't download workpad"
  })
};
const useDownloadWorkpad = () => {
  const notifyService = (0, _services.useNotifyService)();
  const download = useDownloadWorkpadBlob();
  return (0, _react.useCallback)(async workpadId => {
    try {
      const workpadService = (0, _canvas_workpad_service.getCanvasWorkpadService)();
      const workpad = await workpadService.get(workpadId);
      download(workpad, `canvas-workpad-${workpad.name}-${workpad.id}`);
    } catch (err) {
      notifyService.error(err, {
        title: strings.getDownloadFailureErrorMessage()
      });
    }
  }, [notifyService, download]);
};
exports.useDownloadWorkpad = useDownloadWorkpad;
const useDownloadWorkpadBlob = () => {
  return (0, _react.useCallback)((workpad, filename) => {
    const jsonBlob = new Blob([JSON.stringify(workpad)], {
      type: 'application/json'
    });
    _fileSaver.default.saveAs(jsonBlob, `${filename}.json`);
  }, []);
};