"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSettingsServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _capabilities_provider = require("./capabilities_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class AdvancedSettingsServerPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    this.logger = initializerContext.logger.get();
    this.config = initializerContext.config.get();
  }
  setup(core) {
    this.logger.debug('advancedSettings: Setup');
    core.capabilities.registerProvider(() => (0, _capabilities_provider.capabilitiesProvider)(this.config));
    return {};
  }
  start(core) {
    this.logger.debug('advancedSettings: Started');
    return {};
  }
  stop() {}
}
exports.AdvancedSettingsServerPlugin = AdvancedSettingsServerPlugin;