"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantDataClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
var _helpers = require("../lib/data_stream/helpers");
var _documents_data_writer = require("../lib/data_stream/documents_data_writer");
var _find = require("./find");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AIAssistantDataClient {
  constructor(options) {
    var _this$options$spaceId;
    /** Kibana space id the document index are part of */
    (0, _defineProperty2.default)(this, "spaceId", void 0);
    /** User creating, modifying, deleting, or updating a document */
    (0, _defineProperty2.default)(this, "currentUser", void 0);
    (0, _defineProperty2.default)(this, "writerCache", new Map());
    (0, _defineProperty2.default)(this, "indexTemplateAndPattern", void 0);
    (0, _defineProperty2.default)(this, "getWriter", async () => {
      const spaceId = this.spaceId;
      if (this.writerCache.get(spaceId)) {
        return this.writerCache.get(spaceId);
      }
      await this.initializeWriter(spaceId, this.indexTemplateAndPattern.alias);
      return this.writerCache.get(spaceId);
    });
    (0, _defineProperty2.default)(this, "getReader", async () => {
      const indexPatterns = this.indexTemplateAndPattern.alias;
      return {
        search: async request => {
          try {
            const esClient = await this.options.elasticsearchClientPromise;
            return await esClient.search({
              ...request,
              index: indexPatterns,
              ignore_unavailable: true,
              seq_no_primary_term: true
            });
          } catch (err) {
            this.options.logger.error(`Error performing search in AIAssistantDataClient - ${err.message}`);
            throw err;
          }
        }
      };
    });
    (0, _defineProperty2.default)(this, "findDocuments", async ({
      perPage,
      page,
      sortField,
      sortOrder,
      filter,
      fields,
      aggs,
      mSearch
    }) => {
      const esClient = await this.options.elasticsearchClientPromise;
      return (0, _find.findDocuments)({
        esClient,
        fields,
        page,
        perPage,
        filter,
        sortField,
        index: this.indexTemplateAndPattern.alias,
        sortOrder: sortOrder,
        logger: this.options.logger,
        aggs,
        mSearch
      });
    });
    this.options = options;
    this.indexTemplateAndPattern = (0, _helpers.getIndexTemplateAndPattern)(this.options.indexPatternsResourceName, (_this$options$spaceId = this.options.spaceId) !== null && _this$options$spaceId !== void 0 ? _this$options$spaceId : _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING);
    this.currentUser = this.options.currentUser;
    this.spaceId = this.options.spaceId;
  }
  async initializeWriter(spaceId, index) {
    var _this$currentUser, _this$currentUser2;
    const esClient = await this.options.elasticsearchClientPromise;
    const writer = new _documents_data_writer.DocumentsDataWriter({
      esClient,
      spaceId,
      index,
      logger: this.options.logger,
      user: {
        id: (_this$currentUser = this.currentUser) === null || _this$currentUser === void 0 ? void 0 : _this$currentUser.profile_uid,
        name: (_this$currentUser2 = this.currentUser) === null || _this$currentUser2 === void 0 ? void 0 : _this$currentUser2.username
      }
    });
    this.writerCache.set(spaceId, writer);
    return writer;
  }
}
exports.AIAssistantDataClient = AIAssistantDataClient;