"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startSync = exports.StartSyncApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startSync = async ({
  connectorId,
  http
}) => {
  const route = `/internal/content_connectors/connectors/${connectorId}/start_sync`;
  return await (http === null || http === void 0 ? void 0 : http.post(route));
};
exports.startSync = startSync;
const StartSyncApiLogic = exports.StartSyncApiLogic = (0, _create_api_logic.createApiLogic)(['start_sync_api_logic'], startSync, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.index.syncSuccess.message', {
    defaultMessage: 'Successfully scheduled a sync, waiting for a connector to pick it up'
  })
});