"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TruncateHeightSection = TruncateHeightSection;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ToggleButtonContainer = _styled.default.div`
  margin-top: ${({
  theme
}) => theme.euiTheme.size.s}
  user-select: none;
`;
function TruncateHeightSection({
  children,
  previewHeight
}) {
  const contentContainerEl = (0, _react.useRef)(null);
  const [showToggle, setShowToggle] = (0, _react.useState)(true);
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (contentContainerEl.current) {
      const shouldShow = contentContainerEl.current.scrollHeight > previewHeight;
      setShowToggle(shouldShow);
    }
  }, [children, previewHeight]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    ref: contentContainerEl,
    style: {
      overflow: 'hidden',
      maxHeight: isOpen ? 'initial' : previewHeight
    }
  }, children), showToggle ? /*#__PURE__*/_react.default.createElement(ToggleButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmTruncateHeightSectionLink",
    onClick: () => {
      setIsOpen(!isOpen);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    style: {
      transition: 'transform 0.1s',
      transform: `rotate(${isOpen ? 90 : 0}deg)`
    },
    type: "arrowRight"
  }), ' ', isOpen ? _i18n.i18n.translate('xpack.apm.toggleHeight.showLessButtonLabel', {
    defaultMessage: 'Show fewer lines'
  }) : _i18n.i18n.translate('xpack.apm.toggleHeight.showMoreButtonLabel', {
    defaultMessage: 'Show more lines'
  }))) : null);
}