"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformToAlertThrottle = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Given a throttle from a "security_solution" rule this will transform it into an "alerting" "throttle"
 * on their saved object.
 * @params throttle The throttle from a "security_solution" rule
 * @returns The "alerting" throttle
 */
const transformToAlertThrottle = throttle => {
  if (throttle == null || throttle === 'rule' || throttle === 'no_actions') {
    return null;
  } else {
    return throttle;
  }
};
exports.transformToAlertThrottle = transformToAlertThrottle;