/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public final class SearchShardsRequest
extends LegacyActionRequest
implements IndicesRequest.Replaceable {
    private String[] indices;
    private final IndicesOptions indicesOptions;
    @Nullable
    private final QueryBuilder query;
    @Nullable
    private final String routing;
    @Nullable
    private final String preference;
    private final boolean allowPartialSearchResults;
    private final String clusterAlias;

    public SearchShardsRequest(String[] indices, IndicesOptions indicesOptions, QueryBuilder query, String routing, String preference, boolean allowPartialSearchResults, String clusterAlias) {
        this.indices = indices;
        this.indicesOptions = indicesOptions;
        this.query = query;
        this.routing = routing;
        this.preference = preference;
        this.allowPartialSearchResults = allowPartialSearchResults;
        this.clusterAlias = clusterAlias;
    }

    public SearchShardsRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.query = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.allowPartialSearchResults = in.readBoolean();
        this.clusterAlias = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalNamedWriteable(this.query);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.allowPartialSearchResults);
        out.writeOptionalString(this.clusterAlias);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public IndicesRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchTask(id, type, action, this::description, parentTaskId, headers);
    }

    public String clusterAlias() {
        return this.clusterAlias;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public String routing() {
        return this.routing;
    }

    public String preference() {
        return this.preference;
    }

    public boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    private String description() {
        return "indices=" + Arrays.toString(this.indices) + ", indicesOptions=" + String.valueOf(this.indicesOptions) + ", query=" + String.valueOf(this.query) + ", routing='" + this.routing + "', preference='" + this.preference + "', allowPartialSearchResults=" + this.allowPartialSearchResults + ", clusterAlias=" + this.clusterAlias;
    }

    @Override
    public String toString() {
        return "SearchShardsRequest{" + this.description() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardsRequest request = (SearchShardsRequest)o;
        return Arrays.equals(this.indices, request.indices) && Objects.equals(this.indicesOptions, request.indicesOptions) && Objects.equals(this.query, request.query) && Objects.equals(this.routing, request.routing) && Objects.equals(this.preference, request.preference) && this.allowPartialSearchResults == request.allowPartialSearchResults && Objects.equals(this.clusterAlias, request.clusterAlias);
    }

    public int hashCode() {
        int result = Objects.hash(this.indicesOptions, this.query, this.routing, this.preference, this.allowPartialSearchResults, this.clusterAlias);
        result = 31 * result + Arrays.hashCode(this.indices);
        return result;
    }
}

