/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.TransportClusterHealthAction;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.TimeValue;

public class ClusterHealthRequestBuilder
extends MasterNodeReadOperationRequestBuilder<ClusterHealthRequest, ClusterHealthResponse, ClusterHealthRequestBuilder> {
    public ClusterHealthRequestBuilder(ElasticsearchClient client, TimeValue masterNodeTimeout) {
        super(client, TransportClusterHealthAction.TYPE, new ClusterHealthRequest(masterNodeTimeout));
    }

    public ClusterHealthRequestBuilder setIndices(String ... indices) {
        ((ClusterHealthRequest)this.request).indices(indices);
        return this;
    }

    public ClusterHealthRequestBuilder setIndicesOptions(IndicesOptions indicesOptions) {
        ((ClusterHealthRequest)this.request).indicesOptions(indicesOptions);
        return this;
    }

    public ClusterHealthRequestBuilder setTimeout(TimeValue timeout) {
        ((ClusterHealthRequest)this.request).timeout(timeout);
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForStatus(ClusterHealthStatus waitForStatus) {
        ((ClusterHealthRequest)this.request).waitForStatus(waitForStatus);
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForGreenStatus() {
        ((ClusterHealthRequest)this.request).waitForGreenStatus();
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForYellowStatus() {
        ((ClusterHealthRequest)this.request).waitForYellowStatus();
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForNoRelocatingShards(boolean waitForRelocatingShards) {
        ((ClusterHealthRequest)this.request).waitForNoRelocatingShards(waitForRelocatingShards);
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForNoInitializingShards(boolean waitForNoInitializingShards) {
        ((ClusterHealthRequest)this.request).waitForNoInitializingShards(waitForNoInitializingShards);
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        if (waitForActiveShards.equals(ActiveShardCount.DEFAULT)) {
            ((ClusterHealthRequest)this.request).waitForActiveShards(ActiveShardCount.NONE);
        } else {
            ((ClusterHealthRequest)this.request).waitForActiveShards(waitForActiveShards);
        }
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        ((ClusterHealthRequest)this.request).waitForActiveShards(waitForActiveShards);
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForNodes(String waitForNodes) {
        ((ClusterHealthRequest)this.request).waitForNodes(waitForNodes);
        return this;
    }

    public ClusterHealthRequestBuilder setWaitForEvents(Priority waitForEvents) {
        ((ClusterHealthRequest)this.request).waitForEvents(waitForEvents);
        return this;
    }
}

