/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.stats.outlierdetection;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.dataframe.stats.AnalysisStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.Fields;
import org.elasticsearch.xpack.core.ml.dataframe.stats.outlierdetection.Parameters;
import org.elasticsearch.xpack.core.ml.dataframe.stats.outlierdetection.TimingStats;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class OutlierDetectionStats
implements AnalysisStats {
    public static final String TYPE_VALUE = "outlier_detection_stats";
    public static final ParseField PARAMETERS = new ParseField("parameters", new String[0]);
    public static final ParseField TIMING_STATS = new ParseField("timing_stats", new String[0]);
    public static final ConstructingObjectParser<OutlierDetectionStats, Void> STRICT_PARSER = OutlierDetectionStats.createParser(false);
    public static final ConstructingObjectParser<OutlierDetectionStats, Void> LENIENT_PARSER = OutlierDetectionStats.createParser(true);
    private final String jobId;
    private final Instant timestamp;
    private final Parameters parameters;
    private final TimingStats timingStats;

    private static ConstructingObjectParser<OutlierDetectionStats, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(TYPE_VALUE, ignoreUnknownFields, a -> new OutlierDetectionStats((String)a[0], (Instant)a[1], (Parameters)a[2], (TimingStats)a[3]));
        parser.declareString((bucket, s) -> {}, Fields.TYPE);
        parser.declareString(ConstructingObjectParser.constructorArg(), Fields.JOB_ID);
        parser.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, Fields.TIMESTAMP.getPreferredName()), Fields.TIMESTAMP, ObjectParser.ValueType.VALUE);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Parameters.fromXContent(p, ignoreUnknownFields), PARAMETERS);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> TimingStats.fromXContent(p, ignoreUnknownFields), TIMING_STATS);
        return parser;
    }

    public OutlierDetectionStats(String jobId, Instant timestamp, Parameters parameters, TimingStats timingStats) {
        this.jobId = Objects.requireNonNull(jobId);
        this.timestamp = Instant.ofEpochMilli(ExceptionsHelper.requireNonNull(timestamp, Fields.TIMESTAMP).toEpochMilli());
        this.parameters = Objects.requireNonNull(parameters);
        this.timingStats = Objects.requireNonNull(timingStats);
    }

    public OutlierDetectionStats(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = in.readInstant();
        this.parameters = new Parameters(in);
        this.timingStats = new TimingStats(in);
    }

    public String getWriteableName() {
        return TYPE_VALUE;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeInstant(this.timestamp);
        this.parameters.writeTo(out);
        this.timingStats.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(Fields.TYPE.getPreferredName(), TYPE_VALUE);
            builder.field(Fields.JOB_ID.getPreferredName(), this.jobId);
        }
        builder.timestampFieldsFromUnixEpochMillis(Fields.TIMESTAMP.getPreferredName(), Fields.TIMESTAMP.getPreferredName() + "_string", this.timestamp.toEpochMilli());
        builder.field(PARAMETERS.getPreferredName(), (ToXContent)this.parameters);
        builder.field(TIMING_STATS.getPreferredName(), (ToXContent)this.timingStats);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlierDetectionStats that = (OutlierDetectionStats)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.timingStats, that.timingStats);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.parameters, this.timingStats);
    }

    public String documentId(String _jobId) {
        return OutlierDetectionStats.documentIdPrefix(_jobId) + this.timestamp.toEpochMilli();
    }

    public static String documentIdPrefix(String jobId) {
        return "outlier_detection_stats_" + jobId + "_";
    }
}

