/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class SslTrustResolver {
    private Set<File> certificateAuthorities;
    private File trustStoreFile;
    private String trustStorePassword;
    private File serverCertificate;
    private File serverKeyStoreFile;
    private String serverKeyStorePassword;

    SslTrustResolver() {
    }

    public void setCertificateAuthorities(File ... certificateAuthorities) {
        this.certificateAuthorities = new HashSet<File>(Arrays.asList(certificateAuthorities));
    }

    public void setTrustStoreFile(File trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setServerCertificate(File serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    public void setServerKeystoreFile(File keyStoreFile) {
        this.serverKeyStoreFile = keyStoreFile;
    }

    public void setServerKeystorePassword(String keyStorePassword) {
        this.serverKeyStorePassword = keyStorePassword;
    }

    public SSLContext getSslContext() throws GeneralSecurityException, IOException {
        TrustManager[] trustManagers = this.buildTrustManagers();
        if (trustManagers != null) {
            return this.createSslContext(trustManagers);
        }
        return null;
    }

    TrustManager[] buildTrustManagers() throws GeneralSecurityException, IOException {
        long configurationCount = Stream.of(this.certificateAuthorities, this.trustStoreFile, this.serverCertificate, this.serverKeyStoreFile).filter(Objects::nonNull).count();
        if (configurationCount == 0L) {
            return null;
        }
        if (configurationCount > 1L) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Cannot specify more than one trust method (CA=%s, trustStore=%s, serverCert=%s, serverKeyStore=%s)", this.certificateAuthorities, this.trustStoreFile, this.serverCertificate, this.serverKeyStoreFile));
        }
        if (this.certificateAuthorities != null) {
            return this.getTrustManagers(SslTrustResolver.buildTrustStoreFromCA(this.certificateAuthorities));
        }
        if (this.trustStoreFile != null) {
            return this.getTrustManagers(SslTrustResolver.readKeyStoreFromFile(this.trustStoreFile, this.trustStorePassword));
        }
        if (this.serverCertificate != null) {
            return SslTrustResolver.buildTrustManagerFromLeafCertificates(this.head(SslTrustResolver.readCertificates(this.serverCertificate)));
        }
        if (this.serverKeyStoreFile != null) {
            return SslTrustResolver.buildTrustManagerFromLeafCertificates(SslTrustResolver.readCertificatesFromKeystore(this.serverKeyStoreFile, this.serverKeyStorePassword));
        }
        throw new IllegalStateException("Expected to configure trust, but all configuration values are null");
    }

    private SSLContext createSslContext(TrustManager[] trustManagers) throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(new KeyManager[0], trustManagers, new SecureRandom());
        return sslContext;
    }

    private TrustManager[] getTrustManagers(KeyStore trustStore) throws GeneralSecurityException {
        this.checkForTrustEntry(trustStore);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        return tmf.getTrustManagers();
    }

    private void checkForTrustEntry(KeyStore trustStore) throws KeyStoreException {
        Enumeration<String> enumeration = trustStore.aliases();
        while (enumeration.hasMoreElements()) {
            if (!trustStore.isCertificateEntry(enumeration.nextElement())) continue;
            return;
        }
        throw new IllegalStateException("Trust-store does not contain any trusted certificate entries");
    }

    private static KeyStore buildTrustStoreFromCA(Set<File> files) throws GeneralSecurityException, IOException {
        KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
        store.load(null, null);
        int counter = 0;
        for (File ca : files) {
            for (Certificate certificate : SslTrustResolver.readCertificates(ca)) {
                store.setCertificateEntry("cert-" + counter, certificate);
                ++counter;
            }
        }
        return store;
    }

    private static TrustManager[] buildTrustManagerFromLeafCertificates(Collection<? extends Certificate> certificates) {
        final Set trusted = certificates.stream().filter(X509Certificate.class::isInstance).map(X509Certificate.class::cast).collect(Collectors.toUnmodifiableSet());
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                X509Certificate leaf = chain[0];
                if (!trusted.contains(leaf)) {
                    throw new CertificateException("Untrusted leaf certificate: " + String.valueOf(leaf.getSubjectX500Principal()));
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                throw new CertificateException("This trust manager is for client use only and cannot trust other clients");
            }
        };
        return new TrustManager[]{trustManager};
    }

    private static Collection<Certificate> readCertificatesFromKeystore(File file, String password) throws GeneralSecurityException, IOException {
        KeyStore keyStore = SslTrustResolver.readKeyStoreFromFile(file, password);
        HashSet<Certificate> certificates = new HashSet<Certificate>(keyStore.size());
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String alias = enumeration.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            certificates.add(keyStore.getCertificate(alias));
        }
        return certificates;
    }

    private static KeyStore readKeyStoreFromFile(File file, String password) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(file.getName().endsWith(".jks") ? "JKS" : "PKCS12");
        try (FileInputStream input = new FileInputStream(file);){
            keyStore.load(input, password == null ? null : password.toCharArray());
        }
        return keyStore;
    }

    private static Collection<? extends Certificate> readCertificates(File pemFile) throws GeneralSecurityException, IOException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        try (FileInputStream input = new FileInputStream(pemFile);){
            Collection<? extends Certificate> collection = certFactory.generateCertificates(input);
            return collection;
        }
    }

    private Collection<? extends Certificate> head(Collection<? extends Certificate> certificates) {
        if (certificates.isEmpty()) {
            return certificates;
        }
        return List.of(certificates.iterator().next());
    }
}

