/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.api.filtering;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.MappedActionFilter;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.security.operator.OperatorPrivilegesUtil;

public abstract class ApiFilteringActionFilter<Res extends ActionResponse>
implements MappedActionFilter {
    private final ThreadContext threadContext;
    private final String actionName;
    private final Class<Res> responseClass;

    protected ApiFilteringActionFilter(ThreadContext threadContext, String actionName, Class<Res> responseClass) {
        assert (threadContext != null) : "threadContext cannot be null";
        assert (actionName != null) : "actionName cannot be null";
        assert (responseClass != null) : "responseClass cannot be null";
        this.threadContext = threadContext;
        this.actionName = actionName;
        this.responseClass = responseClass;
    }

    public final String actionName() {
        return this.actionName;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        ActionListener responseFilteringListener = !OperatorPrivilegesUtil.isOperator(this.threadContext) && this.actionName.equals(action) ? listener.map(this::filter) : listener;
        chain.proceed(task, action, request, responseFilteringListener);
    }

    private <Response extends ActionResponse> Response filter(Response response) throws Exception {
        if (response.getClass().equals(this.responseClass)) {
            return this.filterResponse(response);
        }
        return response;
    }

    protected abstract Res filterResponse(Res var1) throws Exception;
}

