/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockFactoryProvider;
import org.elasticsearch.compute.operator.exchange.ExchangeService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncSearchSecurity;
import org.elasticsearch.xpack.core.async.AsyncStopRequest;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.GetAsyncResultRequest;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;
import org.elasticsearch.xpack.esql.action.EsqlQueryTask;
import org.elasticsearch.xpack.esql.plugin.TransportEsqlAsyncGetResultsAction;
import org.elasticsearch.xpack.esql.plugin.TransportEsqlQueryAction;

public class TransportEsqlAsyncStopAction
extends HandledTransportAction<AsyncStopRequest, EsqlQueryResponse> {
    private final TransportEsqlQueryAction queryAction;
    private final TransportEsqlAsyncGetResultsAction getResultsAction;
    private final ExchangeService exchangeService;
    private final BlockFactory blockFactory;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final AsyncSearchSecurity security;
    private static final Logger logger = LogManager.getLogger(TransportEsqlAsyncStopAction.class);

    @Inject
    public TransportEsqlAsyncStopAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, TransportEsqlQueryAction queryAction, TransportEsqlAsyncGetResultsAction getResultsAction, Client client, ExchangeService exchangeService, BlockFactoryProvider blockFactoryProvider) {
        super("indices:data/read/esql/async/stop", transportService, actionFilters, AsyncStopRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.queryAction = queryAction;
        this.getResultsAction = getResultsAction;
        this.exchangeService = exchangeService;
        this.blockFactory = blockFactoryProvider.blockFactory();
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.security = new AsyncSearchSecurity(".async-search", new SecurityContext(clusterService.getSettings(), client.threadPool().getThreadContext()), client, "async_search");
    }

    protected void doExecute(Task task, AsyncStopRequest request, ActionListener<EsqlQueryResponse> listener) {
        AsyncExecutionId searchId = AsyncExecutionId.decode((String)request.getId());
        DiscoveryNode node = this.clusterService.state().nodes().get(searchId.getTaskId().getNodeId());
        if (this.clusterService.localNode().getId().equals(searchId.getTaskId().getNodeId()) || node == null) {
            this.stopQueryAndReturnResult(task, searchId, listener);
        } else {
            this.transportService.sendRequest(node, "indices:data/read/esql/async/stop", (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, EsqlQueryResponse.reader(this.blockFactory), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE));
        }
    }

    private String sessionID(AsyncExecutionId asyncId) {
        return new TaskId(this.clusterService.localNode().getId(), asyncId.getTaskId().getId()).toString();
    }

    private void stopQueryAndReturnResult(Task task, AsyncExecutionId asyncId, ActionListener<EsqlQueryResponse> listener) {
        String asyncIdStr = asyncId.getEncoded();
        EsqlQueryTask asyncTask = this.getEsqlQueryTask(asyncId);
        GetAsyncResultRequest getAsyncResultRequest = new GetAsyncResultRequest(asyncIdStr);
        if (asyncTask == null) {
            logger.debug("Async stop for task {}, no task present - passing to GetAsyncResultRequest", (Object)asyncIdStr);
            this.getResultsAction.execute(task, (ActionRequest)getAsyncResultRequest, listener);
            return;
        }
        logger.debug("Async stop for task {} - stopping", (Object)asyncIdStr);
        EsqlExecutionInfo esqlExecutionInfo = asyncTask.executionInfo();
        if (esqlExecutionInfo != null) {
            esqlExecutionInfo.markAsStopped();
        }
        Runnable getResults = () -> this.getResultsAction.execute(task, (ActionRequest)getAsyncResultRequest, listener);
        this.exchangeService.finishSessionEarly(this.sessionID(asyncId), ActionListener.running(() -> {
            if (!asyncTask.addCompletionListener(() -> ActionListener.running((Runnable)getResults))) {
                getResults.run();
            }
        }));
    }

    private EsqlQueryTask getEsqlQueryTask(AsyncExecutionId asyncId) {
        try {
            return (EsqlQueryTask)AsyncTaskIndexService.getTaskAndCheckAuthentication((TaskManager)this.taskManager, (AsyncSearchSecurity)this.security, (AsyncExecutionId)asyncId, EsqlQueryTask.class);
        }
        catch (IOException e) {
            return null;
        }
    }
}

