/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateEmptyRelation;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceStatsFilteredAggWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceStringCasingWithInsensitiveRegexMatch;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.InferIsNotNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.InferNonNullAggConstraint;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.LocalPropagateEmptyRelation;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.ReplaceFieldWithConstantOrNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.ReplaceTopNWithLimitAndSort;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.Rule;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;

public class LocalLogicalPlanOptimizer
extends ParameterizedRuleExecutor<LogicalPlan, LocalLogicalOptimizerContext> {
    private static final List<RuleExecutor.Batch<LogicalPlan>> RULES = CollectionUtils.arrayAsArrayList((Object[])new RuleExecutor.Batch[]{new RuleExecutor.Batch("Local rewrite", RuleExecutor.Limiter.ONCE, new ReplaceTopNWithLimitAndSort(), new ReplaceFieldWithConstantOrNull(), new InferIsNotNull(), new InferNonNullAggConstraint()), LocalLogicalPlanOptimizer.localOperators(), LogicalPlanOptimizer.cleanup()});

    public LocalLogicalPlanOptimizer(LocalLogicalOptimizerContext localLogicalOptimizerContext) {
        super(localLogicalOptimizerContext);
    }

    @Override
    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        return RULES;
    }

    private static RuleExecutor.Batch<LogicalPlan> localOperators() {
        RuleExecutor.Batch<LogicalPlan> operators = LogicalPlanOptimizer.operators(true);
        Rule<?, LogicalPlan>[] rules = operators.rules();
        ArrayList newRules = new ArrayList(rules.length);
        block4: for (Rule<?, LogicalPlan> r : rules) {
            Rule<?, LogicalPlan> rule;
            Objects.requireNonNull(r);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PropagateEmptyRelation.class, ReplaceStatsFilteredAggWithEval.class}, rule, n)) {
                case 0: {
                    PropagateEmptyRelation ignoredPropagate = (PropagateEmptyRelation)rule;
                    newRules.add(new LocalPropagateEmptyRelation());
                    continue block4;
                }
                case 1: {
                    ReplaceStatsFilteredAggWithEval ignoredReplace = (ReplaceStatsFilteredAggWithEval)rule;
                    continue block4;
                }
                default: {
                    newRules.add(r);
                }
            }
        }
        newRules.add(new ReplaceStringCasingWithInsensitiveRegexMatch());
        return operators.with((Rule[])newRules.toArray(Rule[]::new));
    }

    public LogicalPlan localOptimize(LogicalPlan plan) {
        return this.execute(plan);
    }
}

