/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollector;

public class MultiBucketCollector
extends BucketCollector {
    private final boolean terminateIfNoop;
    private final boolean cacheScores;
    private final BucketCollector[] collectors;

    public static BucketCollector wrap(final boolean terminateIfNoop, Iterable<? extends BucketCollector> collectors) {
        int n = 0;
        for (BucketCollector bucketCollector : collectors) {
            if (bucketCollector == NO_OP_BUCKET_COLLECTOR) continue;
            ++n;
        }
        if (n == 0) {
            return NO_OP_BUCKET_COLLECTOR;
        }
        if (n == 1) {
            BucketCollector col = null;
            for (BucketCollector bucketCollector : collectors) {
                if (bucketCollector == null) continue;
                col = bucketCollector;
                break;
            }
            final BucketCollector bucketCollector = col;
            return new BucketCollector(){

                @Override
                public ScoreMode scoreMode() {
                    return bucketCollector.scoreMode();
                }

                @Override
                public void preCollection() throws IOException {
                    bucketCollector.preCollection();
                }

                @Override
                public void postCollection() throws IOException {
                    bucketCollector.postCollection();
                }

                @Override
                public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx) throws IOException {
                    try {
                        LeafBucketCollector leafCollector = bucketCollector.getLeafCollector(aggCtx);
                        if (!leafCollector.isNoop()) {
                            return leafCollector;
                        }
                    }
                    catch (CollectionTerminatedException e) {
                        throw new IllegalStateException("getLeafCollector should return a noop collector instead of throw " + CollectionTerminatedException.class.getSimpleName(), e);
                    }
                    if (terminateIfNoop) {
                        throw new CollectionTerminatedException();
                    }
                    return LeafBucketCollector.NO_OP_COLLECTOR;
                }
            };
        }
        BucketCollector[] colls = new BucketCollector[n];
        n = 0;
        for (BucketCollector bucketCollector : collectors) {
            if (bucketCollector == null) continue;
            colls[n++] = bucketCollector;
        }
        return new MultiBucketCollector(terminateIfNoop, colls);
    }

    private MultiBucketCollector(boolean terminateIfNoop, BucketCollector ... collectors) {
        this.terminateIfNoop = terminateIfNoop;
        this.collectors = collectors;
        int numNeedsScores = 0;
        for (BucketCollector collector : collectors) {
            if (!collector.scoreMode().needsScores()) continue;
            ++numNeedsScores;
        }
        this.cacheScores = numNeedsScores >= 2;
    }

    @Override
    public ScoreMode scoreMode() {
        ScoreMode scoreMode = null;
        for (BucketCollector collector : this.collectors) {
            if (scoreMode == null) {
                scoreMode = collector.scoreMode();
                continue;
            }
            if (scoreMode == collector.scoreMode()) continue;
            return ScoreMode.COMPLETE;
        }
        return scoreMode;
    }

    @Override
    public void preCollection() throws IOException {
        for (BucketCollector collector : this.collectors) {
            collector.preCollection();
        }
    }

    @Override
    public void postCollection() throws IOException {
        for (BucketCollector collector : this.collectors) {
            collector.postCollection();
        }
    }

    public String toString() {
        return Arrays.toString(this.collectors);
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx) throws IOException {
        ArrayList<LeafBucketCollector> leafCollectors = new ArrayList<LeafBucketCollector>(this.collectors.length);
        for (BucketCollector collector : this.collectors) {
            try {
                LeafBucketCollector leafCollector = collector.getLeafCollector(aggCtx);
                if (leafCollector.isNoop()) continue;
                leafCollectors.add(leafCollector);
            }
            catch (CollectionTerminatedException e) {
                throw new IllegalStateException("getLeafCollector should return a noop collector instead of throw " + CollectionTerminatedException.class.getSimpleName(), e);
            }
        }
        return switch (leafCollectors.size()) {
            case 0 -> {
                if (this.terminateIfNoop) {
                    throw new CollectionTerminatedException();
                }
                yield LeafBucketCollector.NO_OP_COLLECTOR;
            }
            case 1 -> (LeafBucketCollector)leafCollectors.get(0);
            default -> new MultiLeafBucketCollector(leafCollectors, this.cacheScores);
        };
    }

    private static class MultiLeafBucketCollector
    extends LeafBucketCollector {
        private final boolean cacheScores;
        private final LeafBucketCollector[] collectors;
        private int numCollectors;
        private ScoreCachingScorable scorable;

        private MultiLeafBucketCollector(List<LeafBucketCollector> collectors, boolean cacheScores) {
            this.collectors = collectors.toArray(new LeafBucketCollector[collectors.size()]);
            this.cacheScores = cacheScores;
            this.numCollectors = this.collectors.length;
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            if (this.cacheScores) {
                this.scorable = new ScoreCachingScorable(scorer);
            }
            for (int i = 0; i < this.numCollectors; ++i) {
                LeafBucketCollector c = this.collectors[i];
                c.setScorer(this.cacheScores ? this.scorable : scorer);
            }
        }

        private void removeCollector(int i) {
            System.arraycopy(this.collectors, i + 1, this.collectors, i, this.numCollectors - i - 1);
            --this.numCollectors;
            this.collectors[this.numCollectors] = null;
        }

        @Override
        public void collect(int doc, long bucket) throws IOException {
            if (this.scorable != null) {
                this.scorable.curDoc = doc;
            }
            LeafBucketCollector[] collectors = this.collectors;
            int numCollectors = this.numCollectors;
            int i = 0;
            while (i < numCollectors) {
                LeafBucketCollector collector = collectors[i];
                try {
                    collector.collect(doc, bucket);
                    ++i;
                }
                catch (CollectionTerminatedException e) {
                    this.removeCollector(i);
                    numCollectors = this.numCollectors;
                    if (numCollectors != 0) continue;
                    throw new CollectionTerminatedException();
                }
            }
        }
    }

    private static class ScoreCachingScorable
    extends Scorable {
        private final Scorable in;
        private int curDoc = -1;
        private int scoreDoc = -1;
        private float score;

        ScoreCachingScorable(Scorable in) {
            this.in = in;
        }

        public float score() throws IOException {
            if (this.curDoc != this.scoreDoc) {
                this.score = this.in.score();
                this.scoreDoc = this.curDoc;
            }
            return this.score;
        }
    }
}

