/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ConstantNullBlock;
import org.elasticsearch.compute.data.FloatArrayBlock;
import org.elasticsearch.compute.data.FloatBigArrayBlock;
import org.elasticsearch.compute.data.FloatBlockBuilder;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.FloatVectorBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.index.mapper.BlockLoader;

public sealed interface FloatBlock
extends Block
permits FloatArrayBlock, FloatVectorBlock, ConstantNullBlock, FloatBigArrayBlock {
    public float getFloat(int var1);

    @Override
    public FloatVector asVector();

    @Override
    public FloatBlock filter(int ... var1);

    @Override
    public FloatBlock keepMask(BooleanVector var1);

    public ReleasableIterator<? extends FloatBlock> lookup(IntBlock var1, ByteSizeValue var2);

    @Override
    public FloatBlock expand();

    public static FloatBlock readFrom(BlockStreamInput in) throws IOException {
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> FloatBlock.readValues(in);
            case 1 -> FloatVector.readFrom(in.blockFactory(), (StreamInput)in).asBlock();
            case 2 -> FloatArrayBlock.readArrayBlock(in.blockFactory(), in);
            case 3 -> FloatBigArrayBlock.readArrayBlock(in.blockFactory(), in);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid block serialization type " + serializationType));
                }
                throw new IllegalStateException("invalid serialization type " + serializationType);
            }
        };
    }

    private static FloatBlock readValues(BlockStreamInput in) throws IOException {
        int positions = in.readVInt();
        try (Builder builder = in.blockFactory().newFloatBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                if (in.readBoolean()) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = in.readVInt();
                builder.beginPositionEntry();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    builder.appendFloat(in.readFloat());
                }
                builder.endPositionEntry();
            }
            FloatBlock floatBlock = builder.build();
            return floatBlock;
        }
    }

    @Override
    default public void writeTo(StreamOutput out) throws IOException {
        FloatBlock floatBlock;
        FloatVector vector = this.asVector();
        TransportVersion version = out.getTransportVersion();
        if (vector != null) {
            out.writeByte((byte)1);
            vector.writeTo(out);
        } else if (version.onOrAfter((VersionId)TransportVersions.V_8_14_0) && (floatBlock = this) instanceof FloatArrayBlock) {
            FloatArrayBlock b = (FloatArrayBlock)floatBlock;
            out.writeByte((byte)2);
            b.writeArrayBlock(out);
        } else if (version.onOrAfter((VersionId)TransportVersions.V_8_14_0) && (floatBlock = this) instanceof FloatBigArrayBlock) {
            FloatBigArrayBlock b = (FloatBigArrayBlock)floatBlock;
            out.writeByte((byte)3);
            b.writeArrayBlock(out);
        } else {
            out.writeByte((byte)0);
            FloatBlock.writeValues(this, out);
        }
    }

    private static void writeValues(FloatBlock block, StreamOutput out) throws IOException {
        int positions = block.getPositionCount();
        out.writeVInt(positions);
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                out.writeBoolean(true);
                continue;
            }
            out.writeBoolean(false);
            int valueCount = block.getValueCount(pos);
            out.writeVInt(valueCount);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                out.writeFloat(block.getFloat(block.getFirstValueIndex(pos) + valueIndex));
            }
        }
    }

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(FloatBlock block1, FloatBlock block2) {
        if (block1 == block2) {
            return true;
        }
        int positions = block1.getPositionCount();
        if (positions != block2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (block1.isNull(pos) || block2.isNull(pos)) {
                if (block1.isNull(pos) == block2.isNull(pos)) continue;
                return false;
            }
            int valueCount = block1.getValueCount(pos);
            if (valueCount != block2.getValueCount(pos)) {
                return false;
            }
            int b1ValueIdx = block1.getFirstValueIndex(pos);
            int b2ValueIdx = block2.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                if (block1.getFloat(b1ValueIdx + valueIndex) == block2.getFloat(b2ValueIdx + valueIndex)) continue;
                return false;
            }
        }
        return true;
    }

    public static int hash(FloatBlock block) {
        int positions = block.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                result = 31 * result - 1;
                continue;
            }
            int valueCount = block.getValueCount(pos);
            result = 31 * result + valueCount;
            int firstValueIdx = block.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                result = 31 * result + Float.floatToIntBits(block.getFloat(pos));
            }
        }
        return result;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static sealed interface Builder
    extends Block.Builder,
    BlockLoader.FloatBuilder
    permits FloatBlockBuilder {
        public Builder appendFloat(float var1);

        public Builder copyFrom(FloatBlock var1, int var2, int var3);

        public Builder copyFrom(FloatBlock var1, int var2);

        @Override
        public Builder appendNull();

        @Override
        public Builder beginPositionEntry();

        @Override
        public Builder endPositionEntry();

        @Override
        public Builder copyFrom(Block var1, int var2, int var3);

        @Override
        public Builder mvOrdering(Block.MvOrdering var1);

        @Override
        public FloatBlock build();
    }
}

