/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupe;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeBytesRef;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

final class BytesRefBlockHash
extends BlockHash {
    private final int channel;
    final BytesRefHash hash;
    private boolean seenNull;

    BytesRefBlockHash(int channel, BlockFactory blockFactory) {
        super(blockFactory);
        this.channel = channel;
        this.hash = new BytesRefHash(1L, blockFactory.bigArrays());
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            this.seenNull = true;
            try (IntVector groupIds = this.blockFactory.newConstantIntVector(0, block.getPositionCount());){
                addInput.add(0, groupIds);
            }
            return;
        }
        BytesRefBlock castBlock = (BytesRefBlock)block;
        BytesRefVector vector = castBlock.asVector();
        if (vector == null) {
            try (IntBlock groupIds = this.add(castBlock);){
                addInput.add(0, groupIds);
            }
            return;
        }
        try (IntVector groupIds = this.add(vector);){
            addInput.add(0, groupIds);
        }
    }

    IntVector add(BytesRefVector vector) {
        OrdinalBytesRefVector ordinals = vector.asOrdinals();
        if (ordinals != null) {
            return this.addOrdinalsVector(ordinals);
        }
        BytesRef scratch = new BytesRef();
        int positions = vector.getPositionCount();
        try (IntVector.FixedBuilder builder = this.blockFactory.newIntVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                BytesRef v = vector.getBytesRef(i, scratch);
                builder.appendInt(Math.toIntExact(BytesRefBlockHash.hashOrdToGroupNullReserved(this.hash.add(v))));
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    IntBlock add(BytesRefBlock block) {
        OrdinalBytesRefBlock ordinals = block.asOrdinals();
        if (ordinals != null) {
            return this.addOrdinalsBlock(ordinals);
        }
        MultivalueDedupe.HashResult result = new MultivalueDedupeBytesRef(block).hashAdd(this.blockFactory, this.hash);
        this.seenNull |= result.sawNull();
        return result.ords();
    }

    @Override
    public ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            return ReleasableIterator.single((Releasable)this.blockFactory.newConstantIntVector(0, block.getPositionCount()).asBlock());
        }
        BytesRefBlock castBlock = (BytesRefBlock)block;
        BytesRefVector vector = castBlock.asVector();
        if (vector == null) {
            return ReleasableIterator.single((Releasable)this.lookup(castBlock));
        }
        return ReleasableIterator.single((Releasable)this.lookup(vector));
    }

    private IntVector addOrdinalsVector(OrdinalBytesRefVector inputBlock) {
        IntVector inputOrds = inputBlock.getOrdinalsVector();
        try (IntVector.Builder builder = this.blockFactory.newIntVectorBuilder(inputOrds.getPositionCount());){
            IntVector intVector;
            block13: {
                IntVector hashOrds = this.add(inputBlock.getDictionaryVector());
                try {
                    for (int p = 0; p < inputOrds.getPositionCount(); ++p) {
                        int ord = hashOrds.getInt(inputOrds.getInt(p));
                        builder.appendInt(ord);
                    }
                    intVector = builder.build();
                    if (hashOrds == null) break block13;
                }
                catch (Throwable throwable) {
                    if (hashOrds != null) {
                        try {
                            hashOrds.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                hashOrds.close();
            }
            return intVector;
        }
    }

    /*
     * Exception decompiling
     */
    private IntBlock addOrdinalsBlock(OrdinalBytesRefBlock inputBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IntBlock lookup(BytesRefVector vector) {
        BytesRef scratch = new BytesRef();
        int positions = vector.getPositionCount();
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                BytesRef v = vector.getBytesRef(i, scratch);
                long found = this.hash.find(v);
                if (found < 0L) {
                    builder.appendNull();
                    continue;
                }
                builder.appendInt(Math.toIntExact(BytesRefBlockHash.hashOrdToGroupNullReserved(found)));
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private IntBlock lookup(BytesRefBlock block) {
        return new MultivalueDedupeBytesRef(block).hashLookup(this.blockFactory, this.hash);
    }

    public BytesRefBlock[] getKeys() {
        BytesRef spare = new BytesRef();
        if (this.seenNull) {
            try (BytesRefBlock.Builder builder = this.blockFactory.newBytesRefBlockBuilder(Math.toIntExact(this.hash.size() + 1L));){
                builder.appendNull();
                for (long i = 0L; i < this.hash.size(); ++i) {
                    builder.appendBytesRef(this.hash.get(i, spare));
                }
                BytesRefBlock[] i = new BytesRefBlock[]{builder.build()};
                return i;
            }
        }
        try (BytesRefBlock.Builder builder = this.blockFactory.newBytesRefBlockBuilder(Math.toIntExact(this.hash.size()));){
            for (long i = 0L; i < this.hash.size(); ++i) {
                builder.appendBytesRef(this.hash.get(i, spare));
            }
            BytesRefBlock[] bytesRefBlockArray = new BytesRefBlock[]{builder.build()};
            return bytesRefBlockArray;
        }
    }

    @Override
    public IntVector nonEmpty() {
        return IntVector.range(this.seenNull ? 0 : 1, Math.toIntExact(this.hash.size() + 1L), this.blockFactory);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(this.seenNull ? 0 : 1, Math.toIntExact(this.hash.size() + 1L)).seenGroupIds(bigArrays);
    }

    public void close() {
        this.hash.close();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BytesRefBlockHash{channel=").append(this.channel);
        b.append(", entries=").append(this.hash.size());
        b.append(", size=").append(ByteSizeValue.ofBytes((long)this.hash.ramBytesUsed()));
        b.append(", seenNull=").append(this.seenNull);
        return b.append('}').toString();
    }
}

