/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestModifier;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.IngestActionForwarder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public abstract class TransportAbstractBulkAction
extends HandledTransportAction<BulkRequest, BulkResponse> {
    private static final Logger logger = LogManager.getLogger(TransportAbstractBulkAction.class);
    protected final ThreadPool threadPool;
    protected final ClusterService clusterService;
    protected final IndexingPressure indexingPressure;
    protected final SystemIndices systemIndices;
    protected final ProjectResolver projectResolver;
    private final IngestService ingestService;
    private final IngestActionForwarder ingestForwarder;
    protected final LongSupplier relativeTimeNanosProvider;
    protected final Executor coordinationExecutor;
    protected final Executor writeExecutor;
    protected final Executor systemWriteExecutor;
    private final ActionType<BulkResponse> bulkAction;

    public TransportAbstractBulkAction(ActionType<BulkResponse> action, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<BulkRequest> requestReader, ThreadPool threadPool, ClusterService clusterService, IngestService ingestService, IndexingPressure indexingPressure, SystemIndices systemIndices, ProjectResolver projectResolver, LongSupplier relativeTimeNanosProvider) {
        super(action.name(), transportService, actionFilters, requestReader, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.ingestService = ingestService;
        this.indexingPressure = indexingPressure;
        this.systemIndices = systemIndices;
        this.projectResolver = projectResolver;
        this.coordinationExecutor = threadPool.executor("write_coordination");
        this.writeExecutor = threadPool.executor("write");
        this.systemWriteExecutor = threadPool.executor("system_write");
        this.ingestForwarder = new IngestActionForwarder(transportService);
        clusterService.addStateApplier(this.ingestForwarder);
        this.relativeTimeNanosProvider = relativeTimeNanosProvider;
        this.bulkAction = action;
    }

    @Override
    protected void doExecute(Task task, BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        int indexingOps = bulkRequest.numberOfActions();
        long indexingBytes = bulkRequest.ramBytesUsed();
        boolean isOnlySystem = TransportBulkAction.isOnlySystem(bulkRequest, this.projectResolver.getProjectMetadata(this.clusterService.state()).getIndicesLookup(), this.systemIndices);
        Object releasable = bulkRequest.incrementalState().indexingPressureAccounted() ? () -> {} : this.indexingPressure.markCoordinatingOperationStarted(indexingOps, indexingBytes, isOnlySystem);
        ActionListener<BulkResponse> releasingListener = ActionListener.runBefore(listener, () -> ((Releasable)releasable).close());
        this.ensureClusterStateThenForkAndExecute(task, bulkRequest, this.coordinationExecutor, isOnlySystem, releasingListener);
    }

    private void ensureClusterStateThenForkAndExecute(final Task task, final BulkRequest bulkRequest, final Executor executor, final boolean isOnlySystem, final ActionListener<BulkResponse> releasingListener) {
        ClusterState initialState = this.clusterService.state();
        ProjectId projectId = this.projectResolver.getProjectId();
        final ClusterBlockException blockException = initialState.blocks().globalBlockedException(projectId, ClusterBlockLevel.WRITE);
        if (blockException != null) {
            if (!blockException.retryable()) {
                releasingListener.onFailure(blockException);
                return;
            }
            logger.trace("cluster is blocked, waiting for it to recover", (Throwable)blockException);
            ClusterStateObserver clusterStateObserver = new ClusterStateObserver(initialState, this.clusterService, bulkRequest.timeout(), logger, this.threadPool.getThreadContext());
            clusterStateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    TransportAbstractBulkAction.this.forkAndExecute(task, bulkRequest, executor, isOnlySystem, releasingListener);
                }

                @Override
                public void onClusterServiceClose() {
                    releasingListener.onFailure(new NodeClosedException(TransportAbstractBulkAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    releasingListener.onFailure(blockException);
                }
            }, newState -> false == newState.blocks().hasGlobalBlockWithLevel(projectId, ClusterBlockLevel.WRITE));
        } else {
            this.forkAndExecute(task, bulkRequest, executor, isOnlySystem, releasingListener);
        }
    }

    private void forkAndExecute(final Task task, final BulkRequest bulkRequest, final Executor executor, final boolean isOnlySystem, final ActionListener<BulkResponse> releasingListener) {
        executor.execute(new ActionRunnable<BulkResponse>(releasingListener){

            @Override
            protected void doRun() throws IOException {
                TransportAbstractBulkAction.this.applyPipelinesAndDoInternalExecute(task, bulkRequest, executor, isOnlySystem, releasingListener);
            }
        });
    }

    private boolean applyPipelines(Task task, BulkRequest bulkRequest, Executor executor, boolean isOnlySystem, ActionListener<BulkResponse> listener) throws IOException {
        Metadata metadata;
        IndexRequest indexRequest;
        boolean hasIndexRequestsWithPipelines = false;
        ClusterState state = this.clusterService.state();
        ProjectId projectId = this.projectResolver.getProjectId();
        Map<String, ComponentTemplate> componentTemplateSubstitutions = bulkRequest.getComponentTemplateSubstitutions();
        Map<String, ComposableIndexTemplate> indexTemplateSubstitutions = bulkRequest.getIndexTemplateSubstitutions();
        if (!(!bulkRequest.isSimulated() || componentTemplateSubstitutions.isEmpty() && indexTemplateSubstitutions.isEmpty())) {
            Metadata originalMetadata = state.metadata();
            Metadata.Builder simulatedMetadataBuilder = Metadata.builder(originalMetadata);
            if (!componentTemplateSubstitutions.isEmpty()) {
                HashMap<String, ComponentTemplate> updatedComponentTemplates = new HashMap<String, ComponentTemplate>();
                updatedComponentTemplates.putAll(originalMetadata.getProject(projectId).componentTemplates());
                updatedComponentTemplates.putAll(componentTemplateSubstitutions);
                simulatedMetadataBuilder.componentTemplates(updatedComponentTemplates);
            }
            if (!indexTemplateSubstitutions.isEmpty()) {
                HashMap<String, ComposableIndexTemplate> updatedIndexTemplates = new HashMap<String, ComposableIndexTemplate>();
                updatedIndexTemplates.putAll(originalMetadata.getProject(projectId).templatesV2());
                updatedIndexTemplates.putAll(indexTemplateSubstitutions);
                simulatedMetadataBuilder.indexTemplates(updatedIndexTemplates);
            }
            for (DocWriteRequest<?> actionRequest : bulkRequest.requests) {
                String indexName;
                assert (actionRequest != null) : "Requests cannot be null in simulate mode";
                assert (actionRequest instanceof IndexRequest) : "Only IndexRequests are supported in simulate mode, but got " + String.valueOf(actionRequest.getClass());
                if (actionRequest == null || (indexName = (indexRequest = (IndexRequest)actionRequest).index()) == null) continue;
                simulatedMetadataBuilder.remove(indexName);
                simulatedMetadataBuilder.removeDataStream(indexName);
            }
            metadata = simulatedMetadataBuilder.build();
        } else {
            metadata = state.getMetadata();
        }
        ProjectMetadata project = metadata.getProject(projectId);
        HashMap<String, IngestService.Pipelines> resolvedPipelineCache = new HashMap<String, IngestService.Pipelines>();
        for (DocWriteRequest<?> actionRequest : bulkRequest.requests) {
            IndexRequest ir;
            indexRequest = TransportAbstractBulkAction.getIndexWriteRequest(actionRequest);
            if (indexRequest != null) {
                if (!indexRequest.isPipelineResolved()) {
                    IngestService.Pipelines pipeline = resolvedPipelineCache.computeIfAbsent(indexRequest.index(), index -> IngestService.resolvePipelines(actionRequest, indexRequest, project, System.currentTimeMillis()));
                    IngestService.setPipelineOnRequest(indexRequest, pipeline);
                }
                hasIndexRequestsWithPipelines |= IngestService.hasPipeline(indexRequest);
            }
            if (!(actionRequest instanceof IndexRequest) || (ir = (IndexRequest)actionRequest).getAutoGeneratedTimestamp() == -1L) continue;
            throw new IllegalArgumentException("autoGeneratedTimestamp should not be set externally");
        }
        if (hasIndexRequestsWithPipelines) {
            ActionListener.run(listener, l -> {
                if (Assertions.ENABLED) {
                    boolean arePipelinesResolved = bulkRequest.requests().stream().map(TransportAbstractBulkAction::getIndexWriteRequest).filter(Objects::nonNull).allMatch(IndexRequest::isPipelineResolved);
                    assert (arePipelinesResolved) : bulkRequest;
                }
                if (this.clusterService.localNode().isIngestNode()) {
                    this.processBulkIndexIngestRequest(task, bulkRequest, executor, isOnlySystem, project, (ActionListener<BulkResponse>)l);
                } else {
                    this.ingestForwarder.forwardIngestRequest(this.bulkAction, bulkRequest, (ActionListener<?>)l);
                }
            });
            return true;
        }
        return false;
    }

    private void processBulkIndexIngestRequest(final Task task, BulkRequest original, final Executor executor, final boolean isOnlySystem, ProjectMetadata metadata, ActionListener<BulkResponse> listener) {
        long ingestStartTimeInNanos = this.relativeTimeNanos();
        BulkRequestModifier bulkRequestModifier = new BulkRequestModifier(original);
        this.getIngestService(original).executeBulkRequest(metadata.id(), original.numberOfActions(), () -> bulkRequestModifier, bulkRequestModifier::markItemAsDropped, indexName -> this.resolveFailureStore((String)indexName, metadata, this.threadPool.absoluteTimeInMillis()), bulkRequestModifier::markItemForFailureStore, bulkRequestModifier::markItemAsFailed, (originalThread, exception) -> {
            if (exception != null) {
                logger.debug("failed to execute pipeline for a bulk request", (Throwable)exception);
                listener.onFailure((Exception)exception);
            } else {
                long ingestTookInMillis = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeNanos() - ingestStartTimeInNanos);
                final BulkRequest bulkRequest = bulkRequestModifier.getBulkRequest();
                final ActionListener<BulkResponse> actionListener = bulkRequestModifier.wrapActionListenerIfNeeded(ingestTookInMillis, listener);
                if (bulkRequest.requests().isEmpty()) {
                    actionListener.onResponse(new BulkResponse(new BulkItemResponse[0], 0L));
                } else {
                    ActionRunnable<BulkResponse> runnable = new ActionRunnable<BulkResponse>(actionListener){

                        @Override
                        protected void doRun() throws IOException {
                            TransportAbstractBulkAction.this.applyPipelinesAndDoInternalExecute(task, bulkRequest, executor, isOnlySystem, actionListener);
                        }

                        @Override
                        public boolean isForceExecution() {
                            return true;
                        }
                    };
                    if (originalThread == Thread.currentThread()) {
                        runnable.run();
                    } else {
                        executor.execute(runnable);
                    }
                }
            }
        }, isOnlySystem ? this.systemWriteExecutor : this.writeExecutor);
    }

    protected abstract Boolean resolveFailureStore(String var1, ProjectMetadata var2, long var3);

    public static IndexRequest getIndexWriteRequest(DocWriteRequest<?> docWriteRequest) {
        IndexRequest indexRequest = null;
        if (docWriteRequest instanceof IndexRequest) {
            indexRequest = (IndexRequest)docWriteRequest;
        } else if (docWriteRequest instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)docWriteRequest;
            indexRequest = updateRequest.docAsUpsert() ? updateRequest.doc() : updateRequest.upsertRequest();
        }
        return indexRequest;
    }

    protected IngestService getIngestService(BulkRequest request) {
        return this.ingestService;
    }

    protected long relativeTimeNanos() {
        return this.relativeTimeNanosProvider.getAsLong();
    }

    protected long buildTookInMillis(long startTimeNanos) {
        return TimeUnit.NANOSECONDS.toMillis(this.relativeTimeNanos() - startTimeNanos);
    }

    private void applyPipelinesAndDoInternalExecute(Task task, BulkRequest bulkRequest, Executor executor, boolean isOnlySystem, ActionListener<BulkResponse> listener) throws IOException {
        long relativeStartTimeNanos = this.relativeTimeNanos();
        if (!this.applyPipelines(task, bulkRequest, executor, isOnlySystem, listener)) {
            this.doInternalExecute(task, bulkRequest, executor, listener, relativeStartTimeNanos);
        }
    }

    protected abstract void doInternalExecute(Task var1, BulkRequest var2, Executor var3, ActionListener<BulkResponse> var4, long var5) throws IOException;
}

