/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverConditions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ilm.ExplainLifecycleRequest;
import org.elasticsearch.xpack.core.ilm.ExplainLifecycleResponse;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleExplainResponse;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.PhaseExecutionInfo;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.WaitForRolloverReadyStep;

public class TransportExplainLifecycleAction
extends TransportLocalProjectMetadataAction<ExplainLifecycleRequest, ExplainLifecycleResponse> {
    private final NamedXContentRegistry xContentRegistry;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportExplainLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, ProjectResolver projectResolver) {
        super("indices:admin/ilm/explain", actionFilters, transportService.getTaskManager(), clusterService, (Executor)threadPool.executor("management"), projectResolver);
        this.xContentRegistry = xContentRegistry;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, ExplainLifecycleRequest::new, (request, channel, task) -> this.executeDirect(task, (ActionRequest)request, (ActionListener)new ChannelActionListener(channel)));
    }

    protected ClusterBlockException checkBlock(ExplainLifecycleRequest request, ProjectState project) {
        return project.blocks().indicesBlockedException(project.projectId(), ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(project.metadata(), (IndicesRequest)request));
    }

    protected void localClusterStateOperation(Task task, ExplainLifecycleRequest request, ProjectState project, ActionListener<ExplainLifecycleResponse> listener) {
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(project.metadata(), (IndicesRequest)request);
        boolean rolloverOnlyIfHasDocuments = (Boolean)LifecycleSettings.LIFECYCLE_ROLLOVER_ONLY_IF_HAS_DOCUMENTS_SETTING.get(project.cluster().metadata().settings());
        TreeMap<String, IndexLifecycleExplainResponse> indexResponses = new TreeMap<String, IndexLifecycleExplainResponse>();
        for (String index : concreteIndices) {
            IndexLifecycleExplainResponse indexResponse;
            try {
                indexResponse = TransportExplainLifecycleAction.getIndexLifecycleExplainResponse(index, project.metadata(), request.onlyErrors(), request.onlyManaged(), this.xContentRegistry, rolloverOnlyIfHasDocuments);
            }
            catch (IOException e) {
                listener.onFailure((Exception)new ElasticsearchParseException("failed to parse phase definition for index [" + index + "]", (Throwable)e, new Object[0]));
                return;
            }
            if (indexResponse == null) continue;
            indexResponses.put(indexResponse.getIndex(), indexResponse);
        }
        ((CancellableTask)task).ensureNotCancelled();
        listener.onResponse((Object)new ExplainLifecycleResponse(indexResponses));
    }

    @Nullable
    static IndexLifecycleExplainResponse getIndexLifecycleExplainResponse(String indexName, ProjectMetadata project, boolean onlyErrors, boolean onlyManaged, NamedXContentRegistry xContentRegistry, boolean rolloverOnlyIfHasDocuments) throws IOException {
        Object indexResponse;
        IndexMetadata indexMetadata = project.index(indexName);
        Settings idxSettings = indexMetadata.getSettings();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        String policyName = indexMetadata.getLifecyclePolicyName();
        String currentPhase = lifecycleState.phase();
        String stepInfo = lifecycleState.stepInfo();
        String previousStepInfo = lifecycleState.previousStepInfo();
        BytesArray stepInfoBytes = null;
        if (stepInfo != null) {
            stepInfoBytes = new BytesArray(stepInfo);
        }
        BytesArray previousStepInfoBytes = null;
        if (previousStepInfo != null) {
            previousStepInfoBytes = new BytesArray(previousStepInfo);
        }
        Long indexCreationDate = indexMetadata.getCreationDate();
        String phaseDef = lifecycleState.phaseDefinition();
        PhaseExecutionInfo phaseExecutionInfo = null;
        if (!Strings.isNullOrEmpty((String)phaseDef)) {
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry), phaseDef);){
                phaseExecutionInfo = PhaseExecutionInfo.parse((XContentParser)parser, (String)currentPhase);
                Phase phase = phaseExecutionInfo.getPhase();
                if (phase != null) {
                    phase.maybeAddDeprecationWarningForFreezeAction(policyName);
                    RolloverAction rolloverAction = (RolloverAction)phase.getActions().get("rollover");
                    if (rolloverAction != null) {
                        RolloverConditions conditions = WaitForRolloverReadyStep.applyDefaultConditions((RolloverConditions)rolloverAction.getConditions(), (boolean)rolloverOnlyIfHasDocuments);
                        phase.getActions().put("rollover", new RolloverAction(conditions));
                    }
                }
            }
        }
        if (project.isIndexManagedByILM(indexMetadata)) {
            Long originationDate;
            IndexLifecycleMetadata indexLifecycleMetadata = (IndexLifecycleMetadata)project.custom("index_lifecycle", (Metadata.ProjectCustom)IndexLifecycleMetadata.EMPTY);
            boolean policyExists = indexLifecycleMetadata.getPolicies().containsKey(policyName);
            indexResponse = !onlyErrors || "ERROR".equals(lifecycleState.step()) || !policyExists ? IndexLifecycleExplainResponse.newManagedIndexResponse((String)indexName, (Long)indexCreationDate, (String)policyName, (Long)((originationDate = idxSettings.getAsLong("index.lifecycle.origination_date", Long.valueOf(-1L))) != -1L ? originationDate : lifecycleState.lifecycleDate()), (String)lifecycleState.phase(), (String)lifecycleState.action(), (String)(!policyExists ? "ERROR" : lifecycleState.step()), (String)lifecycleState.failedStep(), (Boolean)lifecycleState.isAutoRetryableError(), (Integer)lifecycleState.failedStepRetryCount(), (Long)lifecycleState.phaseTime(), (Long)lifecycleState.actionTime(), (Long)lifecycleState.stepTime(), (String)lifecycleState.snapshotRepository(), (String)lifecycleState.snapshotName(), (String)lifecycleState.shrinkIndexName(), (BytesReference)stepInfoBytes, (BytesReference)previousStepInfoBytes, (PhaseExecutionInfo)phaseExecutionInfo, (boolean)((Boolean)LifecycleSettings.LIFECYCLE_SKIP_SETTING.get(idxSettings))) : null;
        } else {
            indexResponse = !onlyManaged && !onlyErrors ? IndexLifecycleExplainResponse.newUnmanagedIndexResponse((String)indexName) : null;
        }
        return indexResponse;
    }
}

