/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.task;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public record ReindexDataStreamStatus(long persistentTaskStartTime, int totalIndices, int totalIndicesToBeUpgraded, boolean complete, Exception exception, Set<String> inProgress, int pending, List<Tuple<String, Exception>> errors) implements Task.Status
{
    public static final String NAME = "ReindexDataStreamStatus";

    public ReindexDataStreamStatus {
        Objects.requireNonNull(inProgress);
        Objects.requireNonNull(errors);
    }

    public ReindexDataStreamStatus(StreamInput in) throws IOException {
        this(in.readLong(), in.readInt(), in.readInt(), in.readBoolean(), in.readException(), in.readCollectionAsSet(StreamInput::readString), in.readInt(), in.readCollectionAsList(in1 -> Tuple.tuple((Object)in1.readString(), (Object)in1.readException())));
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.persistentTaskStartTime);
        out.writeInt(this.totalIndices);
        out.writeInt(this.totalIndicesToBeUpgraded);
        out.writeBoolean(this.complete);
        out.writeException((Throwable)this.exception);
        out.writeStringCollection(this.inProgress);
        out.writeInt(this.pending);
        out.writeCollection(this.errors, (out1, tuple) -> {
            out1.writeString((String)tuple.v1());
            out1.writeException((Throwable)tuple.v2());
        });
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.timestampFieldsFromUnixEpochMillis("start_time_millis", "start_time", this.persistentTaskStartTime);
        builder.field("complete", this.complete);
        builder.field("total_indices_in_data_stream", this.totalIndices);
        builder.field("total_indices_requiring_upgrade", this.totalIndicesToBeUpgraded);
        int inProgressSize = this.inProgress.size();
        builder.field("successes", this.totalIndicesToBeUpgraded - (inProgressSize + this.pending + this.errors.size()));
        builder.field("in_progress", inProgressSize);
        builder.field("pending", this.pending);
        builder.startArray("errors");
        for (Tuple<String, Exception> error : this.errors) {
            builder.startObject();
            builder.field("index", (String)error.v1());
            builder.field("message", ((Exception)error.v2()).getMessage());
            builder.endObject();
        }
        builder.endArray();
        if (this.exception != null) {
            builder.field("exception", this.exception.getMessage());
        }
        builder.endObject();
        return builder;
    }
}

