/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class OverallBucket
implements ToXContentObject,
Writeable {
    public static final ParseField OVERALL_SCORE = new ParseField("overall_score", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField JOBS = new ParseField("jobs", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("overall_buckets", new String[0]);
    public static final String RESULT_TYPE_VALUE = "overall_bucket";
    private final Date timestamp;
    private final long bucketSpan;
    private final double overallScore;
    private final List<JobInfo> jobs;
    private final boolean isInterim;

    public OverallBucket(Date timestamp, long bucketSpan, double overallScore, List<JobInfo> jobs, boolean isInterim) {
        this.timestamp = ExceptionsHelper.requireNonNull(timestamp, Result.TIMESTAMP.getPreferredName());
        this.bucketSpan = bucketSpan;
        this.overallScore = overallScore;
        this.jobs = jobs;
        this.isInterim = isInterim;
    }

    public OverallBucket(StreamInput in) throws IOException {
        this.timestamp = new Date(in.readLong());
        this.bucketSpan = in.readLong();
        this.overallScore = in.readDouble();
        this.jobs = in.readCollectionAsList(JobInfo::new);
        this.isInterim = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.timestamp.getTime());
        out.writeLong(this.bucketSpan);
        out.writeDouble(this.overallScore);
        out.writeCollection(this.jobs);
        out.writeBoolean(this.isInterim);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.timestampFieldsFromUnixEpochMillis(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(OVERALL_SCORE.getPreferredName(), this.overallScore);
        builder.field(JOBS.getPreferredName(), (Iterable<?>)this.jobs);
        builder.field(Result.IS_INTERIM.getPreferredName(), this.isInterim);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.endObject();
        return builder;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getBucketSpan() {
        return this.bucketSpan;
    }

    public double getOverallScore() {
        return this.overallScore;
    }

    public List<JobInfo> getJobs() {
        return this.jobs;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.bucketSpan, this.overallScore, this.jobs, this.isInterim);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OverallBucket)) {
            return false;
        }
        OverallBucket that = (OverallBucket)other;
        return Objects.equals(this.timestamp, that.timestamp) && this.bucketSpan == that.bucketSpan && this.overallScore == that.overallScore && Objects.equals(this.jobs, that.jobs) && this.isInterim == that.isInterim;
    }

    public static class JobInfo
    implements ToXContentObject,
    Writeable,
    Comparable<JobInfo> {
        private static final ParseField MAX_ANOMALY_SCORE = new ParseField("max_anomaly_score", new String[0]);
        private final String jobId;
        private final double maxAnomalyScore;

        public JobInfo(String jobId, double maxAnomalyScore) {
            this.jobId = Objects.requireNonNull(jobId);
            this.maxAnomalyScore = maxAnomalyScore;
        }

        public JobInfo(StreamInput in) throws IOException {
            this.jobId = in.readString();
            this.maxAnomalyScore = in.readDouble();
        }

        public String getJobId() {
            return this.jobId;
        }

        public double getMaxAnomalyScore() {
            return this.maxAnomalyScore;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.jobId);
            out.writeDouble(this.maxAnomalyScore);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(MAX_ANOMALY_SCORE.getPreferredName(), this.maxAnomalyScore);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.maxAnomalyScore);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JobInfo)) {
                return false;
            }
            JobInfo that = (JobInfo)other;
            return Objects.equals(this.jobId, that.jobId) && this.maxAnomalyScore == that.maxAnomalyScore;
        }

        @Override
        public int compareTo(JobInfo other) {
            int result = this.jobId.compareTo(other.jobId);
            if (result == 0) {
                result = Double.compare(this.maxAnomalyScore, other.maxAnomalyScore);
            }
            return result;
        }
    }
}

