/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalGeoCentroid;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.SumAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

final class GeoCentroidAggregator
extends MetricsAggregator {
    private final ValuesSource.GeoPoint valuesSource;
    private DoubleArray lonSum;
    private DoubleArray lonCompensations;
    private DoubleArray latSum;
    private DoubleArray latCompensations;
    private LongArray counts;

    GeoCentroidAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (ValuesSource.GeoPoint)valuesSourceConfig.getValuesSource();
        this.lonSum = this.bigArrays().newDoubleArray(1L, true);
        this.lonCompensations = this.bigArrays().newDoubleArray(1L, true);
        this.latSum = this.bigArrays().newDoubleArray(1L, true);
        this.latCompensations = this.bigArrays().newDoubleArray(1L, true);
        this.counts = this.bigArrays().newLongArray(1L, true);
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        MultiGeoPointValues values = this.valuesSource.geoPointValues(aggCtx.getLeafReaderContext());
        GeoPointValues singleton = FieldData.unwrapSingleton(values);
        return singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(values, sub);
    }

    private LeafBucketCollector getLeafCollector(final MultiGeoPointValues values, LeafBucketCollector sub) {
        final CompensatedSum compensatedSumLat = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumLon = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    GeoCentroidAggregator.this.growBucket(bucket);
                    int valueCount = values.docValueCount();
                    GeoCentroidAggregator.this.counts.increment(bucket, valueCount);
                    compensatedSumLat.reset(GeoCentroidAggregator.this.latSum.get(bucket), GeoCentroidAggregator.this.latCompensations.get(bucket));
                    compensatedSumLon.reset(GeoCentroidAggregator.this.lonSum.get(bucket), GeoCentroidAggregator.this.lonCompensations.get(bucket));
                    for (int i = 0; i < valueCount; ++i) {
                        GeoPoint value = values.nextValue();
                        compensatedSumLat.add(value.getLat());
                        compensatedSumLon.add(value.getLon());
                    }
                    GeoCentroidAggregator.this.lonSum.set(bucket, compensatedSumLon.value());
                    GeoCentroidAggregator.this.lonCompensations.set(bucket, compensatedSumLon.delta());
                    GeoCentroidAggregator.this.latSum.set(bucket, compensatedSumLat.value());
                    GeoCentroidAggregator.this.latCompensations.set(bucket, compensatedSumLat.delta());
                }
            }
        };
    }

    private LeafBucketCollector getLeafCollector(final GeoPointValues values, LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    GeoCentroidAggregator.this.growBucket(bucket);
                    GeoCentroidAggregator.this.counts.increment(bucket, 1L);
                    GeoPoint value = values.pointValue();
                    SumAggregator.computeSum(bucket, value.getLat(), GeoCentroidAggregator.this.latSum, GeoCentroidAggregator.this.latCompensations);
                    SumAggregator.computeSum(bucket, value.getLon(), GeoCentroidAggregator.this.lonSum, GeoCentroidAggregator.this.lonCompensations);
                }
            }
        };
    }

    private void growBucket(long bucket) {
        if (bucket >= this.latSum.size()) {
            long newSize = bucket + 1L;
            this.latSum = this.bigArrays().grow(this.latSum, newSize);
            this.lonSum = this.bigArrays().grow(this.lonSum, newSize);
            this.lonCompensations = this.bigArrays().grow(this.lonCompensations, newSize);
            this.latCompensations = this.bigArrays().grow(this.latCompensations, newSize);
            this.counts = this.bigArrays().grow(this.counts, newSize);
        }
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        long bucketCount = this.counts.get(bucket);
        GeoPoint bucketCentroid = bucketCount > 0L ? new GeoPoint(this.latSum.get(bucket) / (double)bucketCount, this.lonSum.get(bucket) / (double)bucketCount) : null;
        return new InternalGeoCentroid(this.name, bucketCentroid, bucketCount, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalGeoCentroid.empty(this.name, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.latSum, this.latCompensations, this.lonSum, this.lonCompensations, this.counts);
    }
}

