/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.WrappingProcessor;
import org.elasticsearch.script.ScriptService;

public final class ForEachProcessor
extends AbstractProcessor
implements WrappingProcessor {
    public static final String TYPE = "foreach";
    private final String field;
    private final Processor processor;
    private final boolean ignoreMissing;

    ForEachProcessor(String tag, String description, String field, Processor processor, boolean ignoreMissing) {
        super(tag, description);
        this.field = field;
        this.processor = processor;
        this.ignoreMissing = ignoreMissing;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        assert (!this.isAsync());
        Object o = ingestDocument.getFieldValue(this.field, Object.class, this.ignoreMissing);
        if (o == null) {
            if (this.ignoreMissing) {
                return ingestDocument;
            }
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot loop over its elements.");
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            return this.iterateMap(ingestDocument, map);
        }
        if (o instanceof List) {
            List list = (List)o;
            return this.iterateList(ingestDocument, list);
        }
        throw new IllegalArgumentException("field [" + this.field + "] of type [" + o.getClass().getName() + "] cannot be cast to a list or map");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IngestDocument iterateMap(IngestDocument document, Map<?, ?> map) throws Exception {
        Map<String, Object> newValues = Maps.newHashMapWithExpectedSize(map.size());
        for (Map.Entry<?, ?> e : map.entrySet()) {
            String key = (String)e.getKey();
            Object previousKey = document.getIngestMetadata().put("_key", key);
            Object value = e.getValue();
            Object previousValue = document.getIngestMetadata().put("_value", value);
            try {
                this.processor.execute(document);
            }
            finally {
                String newKey = (String)document.getIngestMetadata().get("_key");
                if (Strings.hasText(newKey)) {
                    newValues.put(newKey, document.getIngestMetadata().put("_value", previousValue));
                }
                document.getIngestMetadata().put("_key", previousKey);
            }
        }
        document.setFieldValue(this.field, new HashMap(newValues));
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IngestDocument iterateList(IngestDocument ingestDocument, List<?> values) throws Exception {
        ArrayList<Object> newValues = new ArrayList<Object>(values.size());
        ArrayList iterableValues = new ArrayList(values);
        for (Object value : iterableValues) {
            Object previousValue = ingestDocument.getIngestMetadata().put("_value", value);
            try {
                if ((ingestDocument = this.processor.execute(ingestDocument)) != null) continue;
                IngestDocument ingestDocument2 = null;
                return ingestDocument2;
            }
            finally {
                newValues.add(ingestDocument.getIngestMetadata().put("_value", previousValue));
            }
        }
        ingestDocument.setFieldValue(this.field, newValues);
        return ingestDocument;
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        assert (this.isAsync());
        Object o = ingestDocument.getFieldValue(this.field, Object.class, this.ignoreMissing);
        if (o == null) {
            if (this.ignoreMissing) {
                handler.accept(ingestDocument, null);
            } else {
                handler.accept(null, new IllegalArgumentException("field [" + this.field + "] is null, cannot loop over its elements."));
            }
        } else if (o instanceof Map) {
            Map map = (Map)o;
            ArrayList keys = new ArrayList(map.keySet());
            this.iterateMapAsync(0, new HashMap(map), keys, Maps.newMapWithExpectedSize(map.size()), ingestDocument, handler);
        } else if (o instanceof List) {
            List list = (List)o;
            this.iterateListAsync(0, new ArrayList(list), new ArrayList<Object>(list.size()), ingestDocument, handler);
        } else {
            throw new IllegalArgumentException("field [" + this.field + "] of type [" + o.getClass().getName() + "] cannot be cast to a list or map");
        }
    }

    void iterateMapAsync(int keyIndex, Map<?, ?> map, List<?> keys, Map<Object, Object> newValues, IngestDocument document, BiConsumer<IngestDocument, Exception> handler) {
        while (keyIndex < keys.size()) {
            AtomicBoolean shouldContinueHere = new AtomicBoolean();
            String key = (String)keys.get(keyIndex);
            Object previousKey = document.getIngestMetadata().put("_key", key);
            Object value = map.get(key);
            Object previousValue = document.getIngestMetadata().put("_value", value);
            int nextIndex = keyIndex + 1;
            this.processor.execute(document, (result, e) -> {
                String newKey = (String)document.getIngestMetadata().get("_key");
                if (Strings.hasText(newKey)) {
                    newValues.put(newKey, document.getIngestMetadata().put("_value", previousValue));
                }
                document.getIngestMetadata().put("_key", previousKey);
                if (e != null || result == null) {
                    handler.accept((IngestDocument)result, (Exception)e);
                } else if (shouldContinueHere.getAndSet(true)) {
                    this.iterateMapAsync(nextIndex, map, keys, newValues, document, handler);
                }
            });
            if (!shouldContinueHere.getAndSet(true)) {
                return;
            }
            ++keyIndex;
        }
        if (keyIndex == keys.size()) {
            document.setFieldValue(this.field, new HashMap<Object, Object>(newValues));
            handler.accept(document, null);
        }
    }

    void iterateListAsync(int index, List<?> values, List<Object> newValues, IngestDocument document, BiConsumer<IngestDocument, Exception> handler) {
        while (index < values.size()) {
            AtomicBoolean shouldContinueHere = new AtomicBoolean();
            Object value = values.get(index);
            Object previousValue = document.getIngestMetadata().put("_value", value);
            int nextIndex = index + 1;
            this.processor.execute(document, (result, e) -> {
                newValues.add(document.getIngestMetadata().put("_value", previousValue));
                if (e != null || result == null) {
                    handler.accept((IngestDocument)result, (Exception)e);
                } else if (shouldContinueHere.getAndSet(true)) {
                    this.iterateListAsync(nextIndex, values, newValues, document, handler);
                }
            });
            if (!shouldContinueHere.getAndSet(true)) {
                return;
            }
            ++index;
        }
        if (index == values.size()) {
            document.setFieldValue(this.field, new ArrayList<Object>(newValues));
            handler.accept(document, null);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    @Override
    public Processor getInnerProcessor() {
        return this.processor;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        @Override
        public ForEachProcessor create(Map<String, Processor.Factory> factories, String tag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            String field = ConfigurationUtils.readStringProperty(ForEachProcessor.TYPE, tag, config, "field");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty(ForEachProcessor.TYPE, tag, config, "ignore_missing", false);
            Map processorConfig = ConfigurationUtils.readMap(ForEachProcessor.TYPE, tag, config, "processor");
            Set entries = processorConfig.entrySet();
            if (entries.size() != 1) {
                throw ConfigurationUtils.newConfigurationException(ForEachProcessor.TYPE, tag, "processor", "Must specify exactly one processor type");
            }
            Map.Entry entry = entries.iterator().next();
            Processor processor = ConfigurationUtils.readProcessor(factories, this.scriptService, entry.getKey(), (Map)entry.getValue(), projectId);
            return new ForEachProcessor(tag, description, field, processor, ignoreMissing);
        }
    }
}

